<?php

class TripleContentBlock extends ContentBlock
{

    protected static $singular_name = 'Triple Content';
    protected static $plural_name = 'Triple Content Blocks';

    private static $db = [
        'ContentOneType' => 'Enum("image,text", "text")',
        'ContentTwoType' => 'Enum("image,text", "text")',
        'ContentThreeType' => 'Enum("image,text", "text")',
        'ContentOne' => 'HTMLText',
        'ContentTwo' => 'HTMLText',
        'ContentThree' => 'HTMLText',
    ];

    private static $has_one = [
        'ImageOne' => 'Image',
        'ImageTwo' => 'Image',
        'ImageThree' => 'Image',
    ];

    public function getCMSFields()
    {

        $this->beforeUpdateCMSFields(function (FieldList $fields) {

            foreach (['One', 'Two', 'Three'] as $item) {
                $fields->removeByName("Image{$item}");
            }

            foreach (['One', 'Two', 'Three'] as $item) {
                $fields->addFieldsToTab('Root.Main', [
                    $ddf = DropdownField::create("Content{$item}Type", "Content {$item} Type", [
                        'text' => 'Text',
                        'image' => 'Image'
                    ]),
                    $content = HtmlEditorField::create("Content{$item}"),
                    $image = DisplayLogicWrapper::create(UploadField::create("Image{$item}")),
                ]);
                $content->displayIf("Content{$item}Type")->isEqualTo('text')->end();
                $image->displayIf("Content{$item}Type")->isEqualTo('image')->end();
            }
        });

        $fields = parent::getCMSFields();

        return $fields;
    }

}