<?php

class UserConfig
{
	protected static $config;

	public static function load($config)
	{
		self::$config = $config;
	}

	public static function get($key, $default = null)
	{
		$array = self::$config;
		if (is_null($key)) return $array;
		if (isset($array[$key])) return $array[$key];
		foreach (explode('.', $key) as $segment) {
			if (!is_array($array) || !array_key_exists($segment, $array)) {
				return $default instanceof Closure ? $default() : $default;
			}
			$array = $array[$segment];
		}
		return $array;
	}

	public static function forTemplate()
	{
		return new ArrayData(self::$config);
	}
}