<?php

class FoxysiteGlobalContentExtension extends DataExtension
{

	protected static $db = [
		'Email'            => 'Varchar(255)',
		'GooglePlus'       => 'Varchar(255)',
		'Twitter'          => 'Varchar(255)',
		'Skype'            => 'Varchar(255)',
		'Facebook'         => 'Varchar(255)',
		'Instagram'         => 'Varchar(255)',
		'YouTube'          => 'Varchar(255)',
		'LinkedIn'         => 'Varchar(255)',
		'Footer'           => 'Boolean',
		'PageLinks'        => 'Boolean',
		'Subscribe'        => 'Boolean',
		'Contact'          => 'Boolean',
		'SubscribeSnippet' => 'HTMLText',
		'Phone'            => 'Varchar(255)',
		'Fax'              => 'Varchar(255)',
		'Mobile'           => 'Varchar(255)',
		'Address'          => 'Varchar(255)',
		'ContactText'      => 'HTMLText',
		'StyleOverrides'   => 'Text',

	];
	protected static $has_one = [
		'Logo'         => 'Image',
		'FallbackHero' => 'Image',
		'Favicon'      => 'Image'
	];

	public function updateCMSFields(FieldList $fields)
	{

		$fields->addFieldsToTab('Root.Main', [
				TextField::create('Email', 'Email Address')->setAttribute('placeholder', 'example john@example.com'),
				UploadField::create('Logo', 'Logo'),
				UploadField::create('Favicon', 'Favicon')
			]
		);

		$fields->addFieldToTab('Root.Advanced', $style = new TextareaField('StyleOverrides', 'Custom Style Overrides'));
		$style->setRightTitle('Insert here your custom css overrides. eg: .text { color: white }');

		$fields->addFieldsToTab('Root.SocialMedia', [
				TextField::create('GooglePlus', 'Google Plus')->setAttribute('placeholder', 'https://...'),
				TextField::create('Twitter', 'Twitter')->setAttribute('placeholder', 'https://...'),
				TextField::create('Skype', 'Skype')->setAttribute('placeholder', 'https://...'),
				TextField::create('Facebook', 'Facebook')->setAttribute('placeholder', 'https://...'),
				TextField::create('Instagram', 'Instagram')->setAttribute('placeholder', 'https://...'),
				TextField::create('YouTube', 'YouTube')->setAttribute('placeholder', 'https://...'),
				TextField::create('LinkedIn', 'LinkedIn')->setAttribute('placeholder', 'https://...')
			]
		);

		$fields->addFieldsToTab('Root.Footer', [
				DropdownField::create('Footer', 'Footer Blocks', [0 => 'Disabled', 1 => 'Enabled']),
				$pageLinksVisibilityField = DropdownField::create('PageLinks', 'Footer Page Links', [0 => 'Disabled', 1 => 'Enabled']),
				$contactVisibilityField = DropdownField::create('Contact', 'Footer Contact Block', [0 => 'Disabled', 1 => 'Enabled']),
				$subscribeVisibilityField = DropdownField::create('Subscribe', 'Footer Subscribe Form', [0 => 'Disabled', 1 => 'Enabled']),
				$subscribeSnippetField = TextareaField::create('SubscribeSnippet', 'Subscribe Form Snippet'),
				TextField::create('Phone', 'Phone Number'),
				TextField::create('Fax', 'Fax Number'),
				TextField::create('Mobile', 'Mobile Number'),
				TextField::create('Address', 'Address')->setAttribute('placeholder', 'example 123 Address...'),
				$contactTextVisibility = HtmlEditorField::create('ContactText', 'Contact Block Content')
			]
		);

		$pageLinksVisibilityField->displayIf('Footer')->isEqualTo(true);
		$contactVisibilityField->displayIf('Footer')->isEqualTo(true);
		$contactTextVisibility->displayIf('Footer')->isEqualTo(true)->andIf('Contact')->isEqualTo(true);
		$subscribeVisibilityField->displayIf('Footer')->isEqualTo(true);
		$subscribeSnippetField->displayIf('Footer')->isEqualTo(true)->andIf('Subscribe')->isEqualTo(true);

		$showFallbackHero = $this->owner->config()->get('show_fallback_hero');

		$fields->removeByName('FallbackHero');

		if ($showFallbackHero) {
			$fields->insertAfter('Logo', UploadField::create('FallbackHero', 'Fallback Header Image'));
		}
	}

	/**
	 * @return string
	 */
	public function getFooterColumnClasses()
	{
		$columns = array_sum([
			$this->owner->PageLinks,
			$this->owner->Contact,
			$this->owner->Subscribe
		]);

		switch ($columns) {
			case 1:
				return 'col-sm-12 col-md-12';
			case 2:
				return 'col-sm-12 col-md-6';
			case 3:
				return 'col-sm-12 col-md-4';
		}

	}
}
