<?php

class FoxysiteModuleExtension extends DataExtension
{

	private static $db = [
		'Background' => 'Varchar(50)',
		'ShowInMenu' => 'Boolean',
		'MenuTitle'  => 'Varchar(255)',
		'SortOrder'  => 'Int'
	];

	protected static $default_sort = 'SortOrder';

	public function updateCmsFields(FieldList $fields)
	{

		$fields->insertAfter('Title', DropdownField::create('ShowInMenu', 'Show this item in the navigation menu?', [
				1 => 'Displayed', 0 => 'Hidden']
		));

		$fields->insertAfter('ShowInMenu', $menuTitle = TextField::create('MenuTitle', 'Menu Title')
			->setDescription('If you leave this field empty the menu title will default to the above content title')
		);

		$menuTitle->displayIf('ShowInMenu')->isEqualTo(1);

		$showBackgrounds = $this->owner->config()->get('show_background');

		$fields->removeByName('Background');

		if ($showBackgrounds) {
			$backgrounds = [];
			foreach ($this->owner->config()->get('backgrounds') as $background) {
				$backgrounds[$background] = ucwords($background);
			}
			$fields->insertAfter('MenuTitle', DropdownField::create('Background', null, $backgrounds)->setEmptyString('No background'));
		}

		return $fields;
	}
}
