<?php

class FoxysiteModuleExtension extends DataExtension
{

    private static $db = [
        'Background' => 'Varchar(50)',
        'MenuTitle' => 'Varchar(255)',
        'SortOrder' => 'Int'
    ];

    protected static $default_sort = 'SortOrder';

    public function updateCmsFields(FieldList $fields)
    {

        $singlePageSite = UserConfig::get('SinglePageSite');

        $fields->removeByName('MenuTitle');

        if ($singlePageSite) {
            $fields->addFieldsToTab('Root.Main', [
                TextField::create('MenuTitle', 'Menu Title')->setDescription('If you leave this field empty the menu title will default to the above title')
            ]);
        }

        $showBackgrounds = $this->owner->config()->get('show_background');

        $fields->removeByName('Background');

        if($showBackgrounds) {
            $backgrounds = [];
            foreach ($this->owner->config()->get('backgrounds') as $background) {
                $backgrounds[$background] = ucwords($background);
            }
            $fields->addFieldToTab('Root.Main', DropdownField::create('Background', null, $backgrounds)->setEmptyString('No background'));
        }

        return $fields;
    }
}
