<?php

class FoxysiteModuleExtension extends DataExtension
{

    private static $db = [
        'Background' => 'Varchar(50)',
        'ShowInMenu' => 'Boolean',
        'MenuTitle' => 'Varchar(255)',
        'SortOrder' => 'Int'
    ];

    protected static $default_sort = 'SortOrder';

    private static $defaults = [
        'ShowInMenu' => false
    ];

    public function updateCmsFields(FieldList $fields)
    {

        $backgrounds = [];
        foreach ($this->owner->config()->get('backgrounds') as $type) {
            $backgrounds[$type] = ucwords($type);
        }

        $fields->addFieldsToTab('Root.Main', [
            DropdownField::create('ShowInMenu', 'Show this item in the navigation menu?', [1 => 'Displayed', 0 => 'Hidden']),
            TextField::create('MenuTitle', 'Menu Title')->setDescription('If you leave this field empty the menu title will default to the above content title')
        ]);

        $fields->removeByName('Background');

        if (!!($this->owner->config()->get('show_background'))) $fields->insertAfter('ShowInMenu', DropdownField::create('Background', null, $backgrounds)->setEmptyString('No background'));

        return $fields;
    }
}
