<?php

class MediaItemExtension extends GenericItemExtension {

    private static $db = [
        'Caption'     => 'Varchar(255)',
    ];

    protected static $has_one = [
        'Image' => 'Image'
    ];

    public function updateCmsFields(FieldList $fields) {

        parent::updateCMSFields($fields);

        $fields->addFieldsToTab('Root.Main', [
            TextField::create('Caption', 'Sub Title'),
            UploadField::create('Image', 'Image')->setFolderName("Images/Media-Items")
        ]);

    }
}
