<?php

class FoxysiteModuleExtension extends DataExtension {

    private static $db = [
        'ShowInMenu' => 'Boolean',
        'SortOrder' => 'Int'
    ];

    protected static $default_sort = 'SortOrder';

    private static $defaults = [
        'ShowInMenu' => false
    ];

    public function updateCmsFields(FieldList $fields) {

        $fields->addFieldsToTab('Root.Main', [
            DropdownField::create('ShowInMenu', 'Show this item in the navigation menu?', [1 => 'Displayed', 0 => 'Hidden'])
        ]);

        return $fields;
    }
}
