<?php

class MediaItemExtension extends DataExtension {

    private static $db = [
        'Title'     => 'Varchar(255)',
        'SubTitle'     => 'Varchar(255)',
        'SortOrder' => 'Int'
    ];

    protected static $has_one = [
        'Image' => 'Image'
    ];

    protected static $default_sort = 'SortOrder';

    public function updateCmsFields(FieldList $fields) {

        $fields->addFieldsToTab('Root.Main', [
            TextField::create('Title', 'Title'),
            TextField::create('SubTitle', 'Sub Title'),
            UploadField::create('Image', 'Image')->setFolderName("Images/Media-Items")
        ]);

        return $fields;
    }
}
