<?php

class MediaItemExtension extends DataExtension {

    private static $db = [
        'Title'     => 'Varchar(255)',
        'SubTitle'     => 'Varchar(255)',
        'Displayed' => 'Boolean',
        'SortOrder' => 'Int'
    ];

    protected static $has_one = [
        'Image' => 'Image'
    ];

    private static $defaults = [
        'Displayed' => true
    ];

    protected static $default_sort = 'SortOrder';

    public function updateCmsFields(FieldList $fields) {

        $fields->addFieldsToTab('Root.Main', [
            TextField::create('Title', 'Title'),
            TextField::create('SubTitle', 'Sub Title'),
            DropdownField::create('Displayed', 'Displayed', [1 => 'Displayed', 0 => 'Hidden']),
            UploadField::create('Image', 'Image')->setFolderName("Images/Media-Items")
        ]);

        return $fields;
    }
}
