<?php

class CarouselImage extends DataObject
{
    private static $extensions = [
        'GenericItemExtension', 
        'MediaItemExtension'
    ];

    protected static $has_one = [
        'Carousel'  => 'CarouselContentBlock',
        'Link' => 'Link',
    ]; 

    public function getCMSFields()
    {

        $fields = FieldList::create()->build();
        
        $this->extend('updateCMSFields', $fields);

        $fields->addFieldToTab('Root.Main', LinkField::create('LinkID', 'Link'), 'Image');

        return $fields;
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}
