<?php

class CarouselContentBlock extends ContentBlock
{

    protected static $singular_name = 'Carousel Section';
    protected static $plural_name = 'Carousel Sections';

    private static $db = [
        'FontColor' => 'Varchar(50)',
        'TextAlign' => 'Varchar(50)',
    ];

    private static $has_many = [
        'CarouselImages' => 'CarouselImage',
    ];

    public function getCMSFields()
    {
        $fields = Parent::getCMSFields();

        $showCarouselFontColors = $this->owner->config()->get('show_carousel_font_color');

        $fields->removeByName('FontColor');

        if ($showCarouselFontColors) {
            $colors = [];
            foreach ($this->owner->config()->get('carousel_font_colors') as $color) {
                $colors[$color] = ucwords($color);
            }
            $fields->addFieldToTab('Root.Main', DropdownField::create('FontColor', 'Caption Color', $colors)->setEmptyString('Default'));
        }

        $showCarouselTextAlign = $this->owner->config()->get('show_carousel_text_alignment');

        $fields->removeByName('TextAlign');

        if ($showCarouselTextAlign) {
            $alignments = [];
            foreach ($this->owner->config()->get('carousel_text_alignments') as $alignment) {
                $alignments[$alignment] = ucwords($alignment);
            }
            $fields->addFieldToTab('Root.Main', DropdownField::create('TextAlign', 'Caption Alignment', $alignments)->setEmptyString('Default'));
        }

        $GridFieldConfig = new GridFieldConfig_RecordEditor();
        $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
        $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
        $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
        $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
        $bulkUploadConfig->setUfSetup('setFolderName', "Images/Carousel-Images");
        $GridField = new GridField("CarouselGridField", 'Carousel', $this->CarouselImages(), $GridFieldConfig);

        $fields->addFieldToTab("Root.Main", $GridField);

        $fields->removeByName('CarouselImages');

        return $fields;
    }

    public function IsCarouselShort()
    {
        return ($this->CarouselImages()->first()->Image()->getHeight() < 600);
    }

}
