<?php

class CarouselContentBlock extends ContentBlock
{

    protected static $singular_name = 'Carousel Section';
    protected static $plural_name   = 'Carousel Sections';

    private static $extensions = [
        'FoxysiteModuleExtension' 
    ];

    private static $has_many = [
        'CarouselImages' => 'CarouselImage',
    ];

    public function getCMSFields()
    {
        $fields = Parent::getCMSFields();

        $GridFieldConfig = new GridFieldConfig_RecordEditor();
        $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
        $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
        $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
        $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
        $bulkUploadConfig->setUfSetup('setFolderName', "Images/Carousel-Images");
        $GridField = new GridField("CarouselGridField", 'Carousel', $this->CarouselImages(), $GridFieldConfig);

        $fields->addFieldToTab("Root.Main", $GridField);

        $fields->removeByName('CarouselImages');

        return $fields;
    }
}
