<?php

/**
 * @method SiteTree Page()
 */
class CarouselImage extends DataObject
{

    protected static $db = [
        'Title'     => 'Varchar(255)',
        'SubTitle'     => 'Varchar(255)',
        'Displayed' => 'Boolean',
        'SortOrder' => 'Int'
    ];

    protected static $has_one = [
        'Page'  => 'Page',
        'Image' => 'Image'
    ];

    private static $defaults = [
        'Displayed' => true
    ];

    protected static $default_sort = 'SortOrder';

    public function getCMSFields()
    {

        $fields = new FieldList([
            TextField::create('Title', 'Title'),
            TextField::create('SubTitle', 'Sub Title'),
            DropdownField::create('Displayed', 'Displayed', [1 => 'Displayed', 0 => 'Hidden']),
            UploadField::create('Image', 'Image')->setFolderName("Images/Carousel-Images")
        ]);
        
        $this->extend('updateCMSFields', $fields);

        return $fields;
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}
