<?php

class CarouselExtension extends ContentBlock
{

    private static $has_many = [
        'CarouselImages' => 'CarouselImage',
    ];

    public function updateCMSFields(FieldList $fields)
    {
        $GridFieldConfig = new GridFieldConfig_RecordEditor();
        $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
        $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
        $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
        $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
        $bulkUploadConfig->setUfSetup('setFolderName', "Images/Carousel-Images");
        $GridField = new GridField("CarouselGridField", 'Carousel', $this->CarouselImages(), $GridFieldConfig);

        $fields->addFieldToTab("Root.Main", $GridField);
    }
}
