<?php

/**
 * @property SiteTree $owner
 */
class CarouselExtension extends SiteTreeExtension
{

    private static $has_many = [
        'CarouselImages' => 'CarouselImage',
    ];

    public function updateCMSFields(FieldList $fields)
    {
        $config['title'] = isset($config['title']) ? $config['title'] : "Carousel";
        $config['folder'] = isset($config['folder']) ? $config['folder'] : "Carousel-Images";

        $GridFieldConfig = new GridFieldConfig_RecordEditor();
        $GridFieldConfig->removeComponentsByType('GridFieldAddNewButton');
        $GridFieldConfig->addComponent($bulkUploadConfig = new GridFieldBulkUpload());
        $GridFieldConfig->addComponent(new GridFieldSortableRows('SortOrder'));
        $GridFieldConfig->addComponent(new GridFieldGalleryTheme('Image'));
        $bulkUploadConfig->setUfSetup('setFolderName', "Images/{$config['folder']}");
        $GridField = new GridField("CarouselGridField", $config['title'], $this->owner->{"CarouselImages"}(), $GridFieldConfig);

        /** @var TabSet $rootTab */
        //We need to repush Metadata to ensure it is the last tab
        $rootTab = $fields->fieldByName('Root');
        $rootTab->push($tab = Tab::create("Carousel"));
        if ($rootTab->fieldByName('Metadata')) {
            $metaChildren = $rootTab->fieldByName('Metadata')->getChildren();
            $rootTab->removeByName('Metadata');
            $rootTab->push(Tab::create('Metadata')->setChildren($metaChildren));
        }

        $tab->setTitle($config['title']);
        $fields->addFieldToTab("Root.Carousel", $GridField);
    }
}
