<?php

class BlogContentBlock extends ContentBlock
{

	protected static $singular_name = 'Blog Section';
	protected static $plural_name = 'Blog Sections';

	private static $db = [
		'Images' => 'Boolean'
	];

	private static $has_one = [
		'Blog' => 'Blog'
	];

	public function getCMSFields()
	{
		$this->beforeUpdateCMSFields(function (FieldList $fields) {
			$fields->addFieldsToTab("Root.Main", [
				DropDownField::create('BlogID', 'Blog page', Blog::get()->map('ID', 'Title'))
					->setEmptyString('(Select one)'),
				DropDownField::create('Images', 'Blog posts have Images', [0 => 'No', 1 => 'Yes'])
			]);
		});

		$fields = parent::getCMSFields();

		return $fields;
	}

	public function LatestBlogPosts()
	{
		return BlogPost::get()->sort('Created', 'DESC')->limit(3);
	}
}
