<?php

class BlogContentBlock extends ContentBlock
{

	protected static $singular_name = 'Blog Section';
	protected static $plural_name = 'Blog Sections';

	private static $extensions = [
		'FoxysiteModuleExtension'
	];

	private static $has_one = [
		'Blog' => 'Blog'
	];

	public function getCMSFields()
	{
		$this->beforeUpdateCMSFields(function (FieldList $fields) {
			$fields->addFieldToTab("Root.Main", DropDownField::create('Blog', 'Blog', Blog::get()->map('ID', 'Title'))
				->setEmptyString('(Select one)'));
		});

		$fields = parent::getCMSFields();

		return $fields;
	}
}
