<?php

/**
 * Content side-report listing pages with broken links
 * @package    cms
 * @subpackage content
 */

class ProductsSoldInGivenPeriodReport extends SS_Report
{

    public function title()
    {
        return 'Products sold in given period';
    }

    public function sourceRecords($params, $sort, $limit)
    {
        $returnSet = new ArrayList();
        if (!isset($params['StartDate']) || !isset($params['EndDate'])) {
            return $returnSet;
        }

        $productIDs = FoxcommerceOrder::get()->filter([
            'Created:GreaterThanOrEqual' => $params['StartDate'],
            'Created:LessThanOrEqual'    => $params['EndDate']
        ]);

        if ($productIDs->count()) {
            $productIDs = $productIDs->relation('Items')->column('ProductID');
        } else {
            return $returnSet;
        }


        FoxcommerceProduct::get()
            ->filter(['ID' => $productIDs])
            ->each(function (FoxcommerceProduct $product) use ($returnSet, $productIDs) {
                $returnSet->push(new ArrayData([
                    'Product' => $product,
                    'Sales'   => count(array_filter($productIDs, function ($id) use ($product) {
                        return $product->ID === $id;
                    }))
                ]));
            });

        return $returnSet;
    }

    public function columns()
    {

        $linkBase = singleton('CMSPageEditController')->Link('show');
        $fields   = [
            "Product.InternalItemID" => [
                "title"      => "Product Code",
                "formatting" => function ($value, $item) {
                    return $item->Product->InternalItemID;
                }
            ],
            "Product.Title"          => [
                "title"      => 'Product Name (Click to view in CMS)',
                'formatting' => function ($value, $item) use ($linkBase) {
                    return sprintf('<a href="%s" title="%s">%s</a>',
                        Controller::join_links($linkBase, $item->Product->ID),
                        'Edit Page',
                        $item->Product->Title
                    );
                }
            ],
            "Sales"                  => [
                "title" => 'Total Sales',
            ],
            'AbsoluteLink'           => [
                'title'      => 'URL (Click to view on public site)',
                'formatting' => function ($value, $item) {
                    return sprintf('<a href="%s" target="_blank">%s</a>',
                        $item->Product->AbsoluteLink(),
                        $item->Product->Link()
                    );
                }
            ]
        ];

        return $fields;
    }

    public function parameterFields()
    {
        $fields = new FieldList(
            $startDate = new DateField('StartDate', 'Orders Completed After', date('Y-m-d', strtotime('-6 days'))),
            $endDate = new DateField('EndDate', 'Orders Completed Before', date('Y-m-d'))
        );

        $startDate->setConfig('showcalendar', true);
        $endDate->setConfig('showcalendar', true);

        return $fields;
    }
}
