<?php

/**
 * Class FoxcommerceProductAttributeValueLink
 *
 * @property int $ProductID
 * @property int $AttributeID
 * @property int $AttributeValueID
 * @method FoxcommerceProduct Product()
 * @method FoxcommerceProductAttribute Attribute()
 * @method FoxcommerceProductAttributeValue AttributeValue()
 */
class FoxcommerceProductAttributeValueLink extends DataObject
{

    private static $has_one = [
        'Product'        => 'FoxcommerceProduct',
        'Attribute'      => 'FoxcommerceProductAttribute',
        'AttributeValue' => 'FoxcommerceProductAttributeValue'
    ];

    private static $cart_summary = [
        'ID',
        'getAttributeTitle' => 'Attribute',
    ];

    private static $cart_summary_relations = [
        'AttributeValue' => 'Value'
    ];

    public function getTitle()
    {
        if (!$this->getIsComplete()) {
            return 'Broken Attribute Link';
        }

        return $this->Product()->Title . ' ' . $this->Attribute()->Title . ' ' . $this->AttributeValue()->Title;
    }

    public function getIsComplete()
    {
        return ($this->ProductID && $this->AttributeID && $this->AttributeValueID);
    }

    public function getAttributeTitle()
    {
        return $this->Attribute()->Title;
    }

    public function getDescription()
    {
        return ['label' => $this->Attribute()->Title, 'value' => $this->AttributeValue()];
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}