<?php

/**
 * Class FoxcommerceProductAttributeValue
 *
 * This class should be extended and a has_one 'Attribute' => 'MyCustomProductAttribute' added
 *
 * @property string $Title
 * @property int    $Version
 * @mixin Versioned('Live')
 */
class FoxcommerceProductAttributeValue extends DataObject
{

    protected static $singular_name = 'Attribute Value';
    protected static $plural_name   = 'Attribute Values';

    protected static $db = [
        'Title'     => 'Varchar(255)',
        'SortOrder' => 'Int'
    ];

    protected static $has_many = [
        'AttributeValueLinks' => 'FoxcommerceProductAttributeValueLink'
    ];

    static $extensions = array(
        "Versioned('Live')"
    );

    private static $summary_fields = [
        'Title' => 'Title',
    ];

    protected static $default_sort = 'SortOrder';

    public function getCMSFields()
    {
        $fields = new FieldList([
            TextField::create('Title')->setPlaceholder('e.g. Green'),
        ]);

        $this->extend('updateCMSFields', $fields);

        return $fields;
    }

    public function getMenuTitle()
    {
        return $this->Title;
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

}