<?php

/**
 * Class FoxcommerceProductAttribute
 * 
 * This class should be extended and a has_many 'Values' => 'MyCustomProductAttributeValue' added
 *
 * @property string $Title
 * @property int $Version
 * @method DataList|FoxcommerceProductAttributeValue[] Values()
 * @method ManyManyList|FoxcommerceProduct[] Products()
 * @mixin Versioned('Live')
 */
class FoxcommerceProductAttribute extends DataObject
{

    protected static $singular_name = 'Product Attribute';
    protected static $plural_name   = 'Product Attribute';

    protected static $extensions = array(
        "Versioned('Live')"
    );

    protected static $db = [
        'Title' => 'Varchar(255)',
    ];

    private static $belongs_many_many = [
        'Products' => 'FoxcommerceProduct'
    ];

    private static $has_many = [
        'Values' => 'FoxcommerceProductAttributeValue'
    ];

    private static $summary_fields = [
        'ID'           => 'ID',
        'Title'        => 'Title',
        'Values.Count' => 'Values'
    ];

    public function getCMSFields()
    {

        $AttributeValueConfig = new GridFieldConfig_RecordEditor(200);
        $AttributeValueConfig->addComponent(new GridFieldOrderableRows('SortOrder'));
        $AttributeValue       = new GridField("Values", "Attribute Values", $this->Values(),
            $AttributeValueConfig);

        $fields = new FieldList([
            TextField::create('Title')->setPlaceholder('e.g. Colour'),
            $AttributeValue
        ]);

        $this->extend('updateCMSFields', $fields);

        return $fields;
    }

    public function requireDefaultRecords()
    {
        if (get_class($this) === __CLASS__) {
            return;
        }

        if (!static::get_one(get_class($this))) {
            /** @var self $config */
            $config = new static();
            $config->write();

            DB::alteration_message('Created attribute ' . get_class($this), 'created');
        }
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

}