<?php

/**
 * Class FoxcommerceProductCategory
 *
 */
class FoxcommerceProductCategory extends Page
{

    protected static $singular_name = 'Product Category';
    protected static $plural_name   = 'Product Categories';

    protected static $allowed_children = ['FoxcommerceProduct'];

    protected static $icon = 'foxcommerce/images/product-category-icon.png';


}

/**
 * Class FoxcommerceProductCategory_Controller
 *
 * @property FoxcommerceProductCategory dataRecord
 * @method FoxcommerceProductCategory data()
 * @mixin FoxcommerceProductCategory dataRecord
 */
class FoxcommerceProductCategory_Controller extends Page_Controller
{
    public function CartInitialState()
    {

        $state = FoxcommerceHelper::initial_state();

        /** @var ArrayList $categoryProducts */
        $categoryProducts = $this->Children();
        foreach ($categoryProducts as $product) {
            $state['products'][]          = FoxcommerceHelper::build_cart_summary($product);
            $state['productsDisplayed'][] = $product->ID;
        }

        return json_encode($state);
    }
}
