<?php

/**
 * Class FoxcommerceCartPage
 *
 * @property int $ContinueShoppingPageID
 * @method Page ContinueShoppingPage()
 */
class FoxcommerceCartPage extends Page
{

    protected static $singular_name = 'Cart Page';
    protected static $plural_name   = 'Cart Pages';

    protected static $icon = 'foxcommerce/images/basket-icon.png';

    private static $db = [
    ];

    private static $has_one = [
        'ContinueShoppingPage' => 'Page'
    ];

    function requireDefaultRecords()
    {
        if (self::config()->get('skip_creation')) {
            DB::alteration_message(get_class($this) . ' creation disabled by configuration.', 'error');
            return;
        }
        if (!FoxcommerceCartPage::get_one('FoxcommerceCartPage')) {
            $page             = new FoxcommerceCartPage();
            $page->Title      = 'Cart';
            $page->Content    = '';
            $page->URLSegment = 'cart';
            $page->Status     = 'Published';
            $page->Sort       = 1;
            $page->write();
            $page->publish('Stage', 'Live');
            $page->flushCache();
            DB::alteration_message('Cart page created', 'created');
        }
    }

    public function getCMSFields()
    {

        $this->beforeUpdateCMSFields(function (FieldList $fields) {
            $fields->addFieldsToTab('Root.Main', [
                TreeDropdownField::create('ContinueShoppingPageID', 'Continue Shopping Page', 'SiteTree')
            ],'Content');
        });

        $fields = parent::getCMSFields();


        return $fields;
    }

}

/**
 * Class FoxcommerceCartPage_Controller
 *
 * @property FoxcommerceCartPage dataRecord
 * @method FoxcommerceCartPage data()
 * @mixin FoxcommerceCartPage dataRecord
 */
class FoxcommerceCartPage_Controller extends Page_Controller
{
    protected static $allowed_actions = [
        'CartForm'
    ];

    public function init()
    {
        parent::init();
    }

    public function CartForm()
    {
        return CartForm::create($this);
    }
}
