<?php

/**
 * Class FoxcommerceAccountPage
 *
 */
class FoxcommerceAccountPage extends Page
{

    protected static $singular_name = 'Account Page';
    protected static $plural_name   = 'Account Pages';

    protected static $icon = 'foxcommerce/images/account-icon.png';

    private static $db = [
    ];

    function requireDefaultRecords()
    {
        if (!FoxcommerceAccountPage::get_one('FoxcommerceAccountPage')) {
            $page             = new FoxcommerceAccountPage();
            $page->Title      = 'Account';
            $page->Content    = '';
            $page->URLSegment = 'account';
            $page->Status     = 'Published';
            $page->Sort       = 1;
            $page->write();
            $page->publish('Stage', 'Live');
            $page->flushCache();
            DB::alteration_message('Account page created', 'created');
        }
    }

    public function getCMSFields()
    {

        $this->beforeUpdateCMSFields(function (FieldList $fields) {
        });

        $fields = parent::getCMSFields();


        return $fields;
    }

    /**
     * @return FoxcommerceAccountPage
     * @throws Exception
     */
    public static function getInstance()
    {
        $accountPage = FoxcommerceAccountPage::get_one('FoxcommerceAccountPage');
        if (!$accountPage) throw new Exception('No FoxcommerceAccountPage found');

        return $accountPage;
    }

    public static function addressEditLink($id)
    {
        return self::getInstance()->Link("my-addresses/manage/{$id}");
    }

    public static function addressDeleteLink($id)
    {
        return self::getInstance()->Link("my-addresses/delete/{$id}");
    }

}

/**
 * Class FoxcommerceAccountPage_Controller
 *
 * @property FoxcommerceAccountPage dataRecord
 * @method FoxcommerceAccountPage data()
 * @mixin FoxcommerceAccountPage dataRecord
 */
class FoxcommerceAccountPage_Controller extends Page_Controller
{

    protected static $allowed_actions = [
        'resumeOrder',
        'holdOrder',
        'previousOrders',
        'previousOrdersForm',
        'myDetails',
        'myDetailsForm',
        'changePassword',
        'changePasswordForm',
        'myAddresses',
        'createAddress',
        'changeAddress',
        'archiveAddress',
        'changeAddressForm',
        'logout'
    ];

    protected static $url_handlers = [
        'previous-orders/resume/$ID'     => 'resumeOrder',
        'previous-orders/hold/$ID'       => 'holdOrder',
        'previous-orders/$ID/$OtherID'   => 'previousOrders',
        'my-details/update'              => 'myDetailsForm',
        'my-details/$ID/$OtherID'        => 'myDetails',
        'change-password/update'         => 'changePasswordForm',
        'change-password/$ID/$OtherID'   => 'changePassword',
        'my-addresses/manage/$ID/update' => 'changeAddressForm',
        'my-addresses/update'            => 'changeAddressForm',
        'my-addresses/create'            => 'createAddress',
        'my-addresses/manage/$ID'        => 'changeAddress',
        'my-addresses/delete/$ID'        => 'archiveAddress',
        'my-addresses/$ID/$OtherID'      => 'myAddresses',
        'logout/$ID/$OtherID'            => 'logout'
    ];

    public function init()
    {
        parent::init();

        if (!Member::currentUser()) {
            Security::permissionFailure($this, 'Please login to manage your account');
        }
    }

    public function holdOrder(SS_HTTPRequest $request)
    {
        /** @var FoxcommerceOrder $order */
        $order = Member::currentUser()->FoxcommerceOrders()->byID($request->param('ID'));
        if (!$order) {
            $this->httpError('404');
        }
        if (!$order->getIsCurrent()) {
            Session::set('order.management.message.content', "That order is not active");
            Session::set('order.management.message.type', 'bad');
            return $this->redirectBack();
        }

        Session::set('order.management.message.content', "The order has been placed on hold and a new order started");
        Session::set('order.management.message.type', 'good');
        $order->disassociate();
        return $this->redirectBack();
    }

    public function resumeOrder(SS_HTTPRequest $request)
    {

        /** @var FoxcommerceOrder $order */
        $order = Member::currentUser()->FoxcommerceOrders()->byID($request->param('ID'));
        if (!$order) {
            $this->httpError('404');
        }
        if ($order->getIsCurrent()) {
            Session::set('order.management.message.content', "That order is already active");
            Session::set('order.management.message.type', 'bad');
            return $this->redirectBack();
        }

        $currentOrder = FoxcommerceOrder::current();
        if ($currentOrder && $currentOrder->exists()) {
            $currentOrder->disassociate();

            Session::set('order.management.message.content', "Your current order has been placed on hold and the selected order loaded");
            Session::set('order.management.message.type', 'good');
        } else {
            Session::set('order.management.message.content', "The selected order has been loaded");
            Session::set('order.management.message.type', 'good');
        }

        $order->reassociate();

        return $this->redirectBack();
    }

    public function previousOrders(SS_HTTPRequest $request)
    {

        $message = false;
        if (Session::get('order.management.message.content')) {
            $message = [
                'Content' => Session::get('order.management.message.content'),
                'Type'    => Session::get('order.management.message.type')
            ];
            Session::clear('order.management.message.content');
            Session::clear('order.management.message.type');
        }

        return $this->customise([
            'Section' => 'Previous Orders',
            'Content' => '',
            'Orders'  => Member::currentUser()->FoxcommerceOrders(),
            'Message' => $message
        ]);
    }

    public function myDetails(SS_HTTPRequest $request)
    {

        return $this->customise([
            'Section' => 'My Details',
            'Content' => '',
            'Form'    => $this->myDetailsForm()
        ]);

    }

    public function myDetailsForm()
    {
        return new FoxcommerceAccountDetailsForm($this, 'my-details/update');
    }

    public function changePassword(SS_HTTPRequest $request)
    {

        return $this->customise([
            'Section' => 'Change Password',
            'Content' => '',
            'Form'    => $this->changePasswordForm()
        ]);

    }

    public function changePasswordForm()
    {
        return new FoxcommerceChangePasswordForm($this, 'change-password/update');
    }

    public function myAddresses(SS_HTTPRequest $request)
    {

        $content = new HTMLText();
        $content->setValue('<p>You may select an action below to modify your addresses</p>');
        $form        = $this->changeAddressForm();
        $message     = $form->Message();
        $messageType = $form->MessageType();
        $form->clearMessage();

        return $this->customise([
            'Section'                => 'My Addresses',
            'Content'                => $content,
            'Message'                => $message,
            'MessageType'            => $messageType,
            'Addresses'              => Member::currentUser()->AllAddresses(),
            'BillingAddresses'       => Member::currentUser()->BillingAddresses(),
            'ShippingAddresses'      => Member::currentUser()->ShippingAddresses(),
            'DefaultBillingAddress'  => Member::currentUser()->DefaultBillingAddress(),
            'DefaultShippingAddress' => Member::currentUser()->DefaultShippingAddress(),
        ]);
    }

    public function changeAddress(SS_HTTPRequest $request)
    {
        $address = Member::currentUser()->AllAddresses()->byID($request->param('ID'));

        $form = $this->changeAddressForm();
        $form->loadDataFrom($address);

        return $this->customise([
            'Section' => 'My Addresses',
            'Content' => '',
            'Form'    => $form,
            'Address' => $address
        ]);
    }

    public function createAddress(SS_HTTPRequest $request)
    {
        $form = $this->changeAddressForm();
        $form->loadDataFrom(new FoxcommerceAddress());

        return $this->customise([
            'Section' => 'My Addresses',
            'Content' => '',
            'Form'    => $form
        ]);
    }

    public function archiveAddress(SS_HTTPRequest $request)
    {
        /** @var FoxcommerceAddress $address */
        $address           = Member::currentUser()->AllAddresses()->byID($request->param('ID'));
        $address->Archived = true;
        $address->write();

        return $this->redirectBack();
    }

    public function changeAddressForm()
    {
        $form = new FoxcommerceAddressForm($this, 'my-addresses/update');

        return $form;

    }

    public function logout(SS_HTTPRequest $request)
    {

    }

}
