<?php

/**
 * Class FoxcommerceOrderModifier
 * 
 * Automatic: Attempts to apply the modifier as soon as the Order is created
 * Manual: Only applies the modifier when explicitly added to the order
 * 
 * Automatic: Updates the value of the modifier on every change
 * Manual: Updates the value only when {@see updateValue()} is called
 * 
 * At what stage of the order calculation should the modifier be applied
 * 
 * A Deduction modifier reduces the price of the order
 * An Addition modifier increases the price of the order
 * 
 * An exclusive modifier will remove any other instances of it's class if
 * another modifier of the same class is applied
 * 
 * Flag whether the modifier has been applied to the order.
 * If not it will likely be discarded
 * 
 * A modifier may need to stick around even if it doesn't affect the current order so it can be recalculated
 * at a later date in which case {@see $IsApplied} would be true, this flag allows us to hide it from the cart summary
 * 
 * An exclusive modifier will remove any other instances of it's class if
 * another modifier of the same class is applied
 * Flag whether the modifier has been applied to the order.
 * If not it will likely be discarded
 * A modifier may need to stick around even if it doesn't affect the current order so it can be recalculated
 * at a later date in which case {@see $IsApplied} would be true, this flag allows us to hide it from the cart summary
 * 
 * An exclusive modifier will remove any other instances of it's class if
 * another modifier of the same class is applied
 * Flag whether the modifier has been applied to the order.
 * If not it will likely be discarded
 * A modifier may need to stick around even if it doesn't affect the current order so it can be recalculated
 * at a later date in which case {@see $IsApplied} would be true, this flag allows us to hide it from the cart summary
 * 
 * An exclusive modifier will remove any other instances of it's class if
 * another modifier of the same class is applied
 * Flag whether the modifier has been applied to the order.
 * If not it will likely be discarded
 * A modifier may need to stick around even if it doesn't affect the current order so it can be recalculated
 * at a later date in which case {@see $IsApplied} would be true, this flag allows us to hide it from the cart summary
 *
 * @property string $Title
 * @property string $ApplicationTrigger
 * @property string $RecalculationTrigger
 * @property string $ApplicationStage
 * @property string $ModifierType
 * @property boolean $Exclusive
 * An exclusive modifier will remove any other instances of it's class if
 * another modifier of the same class is applied
 * @property boolean $IsApplied
 * Flag whether the modifier has been applied to the order.
 * If not it will likely be discarded
 * @property boolean $VisibleIfEmpty
 * A modifier may need to stick around even if it doesn't affect the current order so it can be recalculated
 * at a later date in which case {@see $IsApplied} would be true, this flag allows us to hide it from the cart summary
 */
class FoxcommerceOrderModifier extends DataObject
{

    protected static $singular_name = 'Order Modifier';
    protected static $plural_name   = 'Order Modifiers';
    protected static $enabled       = true;

    /** @var  FoxcommerceOrder */
    public $order;

    protected static $db = [
        'Title'                => 'Varchar(255)',
        'ApplicationTrigger'   => 'Enum("Automatic,Manual", "Automatic")',
        'RecalculationTrigger' => 'Enum("Automatic,Manual", "Automatic")',
        'ApplicationStage'     => 'Varchar',
        'ModifierType'         => 'Enum("Deduction,Addition","Deduction")',
        'Exclusive'            => 'Boolean',
        'IsApplied'            => 'Boolean',
        'VisibleIfEmpty'       => 'Boolean'
    ];

    protected static $defaults                  = [
        'ApplicationTrigger'   => 'Automatic',
        'RecalculationTrigger' => 'Automatic',
        'ApplicationStage'     => 'Subtotal',
        'ModifierType'         => 'Deduction',
        'Exclusive'            => true,
        'IsApplied'            => false,
        'VisibleIfEmpty'       => false
    ];
    protected static $requiring_default_records = false;

    public function setOrder(FoxcommerceOrder $order){
        $this->order = $order;
    }

    public function requireDefaultRecords()
    {
        if (get_class($this) === __CLASS__) {
            return;
        }

        Config::inst()->update(get_class($this), 'requiring_default_records', true);
        if (!static::get_one(get_class($this))) {
            /** @var self $config */
            $config = new static();
            $config->write();

            DB::alteration_message('Created order modified ' . get_class($this), 'created');
        }
        parent::requireDefaultRecords();
        Config::inst()->update(get_class($this), 'requiring_default_records', false);

    }

    public function write($showDebug = false, $forceInsert = false, $forceWrite = false, $writeComponents = false)
    {
        if (!$this->stat('requiring_default_records')) {
            throw new Exception('write should not be called on Order Modifiers unless they are being created initially');
        } else {
            return parent::write($showDebug, $forceInsert, $forceWrite, $writeComponents);
        }
    }

    public function calculateForOrder(FoxcommerceOrder $order)
    {
        return "0";
    }

    public function calculateForDisplay(FoxcommerceOrder $order){
        return $this->calculateForOrder($order);
    }

    public function getDescription(){
        $description = false;
        $this->extend('updateDescription', $description);
        return $description;
    }


}