<?php

/**
 * Class FoxcommerceAppliedOrderModifier
 *
 * @property float  $Amount
 * @property string $ModifierClassName
 * @property int    $OrderID
 * @property int    $ModifierID
 * @method FoxcommerceOrder Order()
 */
class FoxcommerceAppliedOrderModifier extends DataObject
{
    private static $db = [
        'Amount'            => 'FixedDecimal',
        'ModifierClassName' => 'Varchar'
    ];

    private static $has_one = [
        'Order'    => 'FoxcommerceOrder',
        'Modifier' => 'FoxcommerceOrderModifier'
    ];

    protected static $cart_summary = [
        'Modifier.Title'         => 'Title',
        'getModifierDescription' => 'Description',
        'Modifier.ModifierType'  => 'Type',
        'ModifierClassName'      => 'ClassName',
        'Amount'                 => 'Amount',
        'getDisplayAmount'       => 'DisplayAmount',
        'getShouldDisplay'       => 'ShouldDisplay'
    ];

    public function Modifier()
    {

        /** @var FoxcommerceOrderModifier $modifier */
        $modifier = $this->getComponent('Modifier');
        $modifier->setOrder($this->Order());

        return $modifier;
    }

    public function getModifierDescription()
    {
        return $this->Modifier()->getDescription();
    }

    public function updateModifier()
    {
        $updatedModifier = $this->Modifier()->updateModifier($this);
    }

    public function getShouldDisplay()
    {
        return $this->Amount != 0 || $this->getDisplayAmount() != '$0.00' || $this->Modifier()->VisibleIfEmpty;
    }

    public function getDisplayAmount()
    {
        $country = $this->Order()->Country();
        if ($this->Modifier()->hasMethod('calculateForDisplay')) {
            $amount = $this->Modifier()->calculateForDisplay($this->Order());
            if (!is_numeric($amount)) return $amount;
        } else {
            $amount = $this->Amount;
        }

        /** @var float $exchangedPrice */
        $exchangedPrice = (bcmul($amount, $country->Currency()->ExchangeRate)) ?: "0";

        $oldLocale      = setlocale(LC_MONETARY, $country->LocaleCode);
        $formattedPrice = money_format('%.2n', $exchangedPrice);
        setlocale(LC_MONETARY, $oldLocale);
        return $formattedPrice;
    }

    function forTemplate()
    {
        return $this->renderWith("{$this->ModifierClassName}Row");
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }


}