<?php

/**
 * Class FoxcommerceOrderItemAttributeValueLink
 *
 * @property int $AttributeVersionID
 * @property int $AttributeValueVersionID
 * @property int $OrderItemID
 * @property int $AttributeID
 * @property int $AttributeValueID
 * @method FoxcommerceOrderItem OrderItem()
 */
class FoxcommerceOrderItemAttributeValueLink extends DataObject
{


    private static $db = [
        'AttributeVersionID'      => 'Int',
        'AttributeValueVersionID' => 'Int'
    ];

    private static $has_one = [
        'OrderItem'      => 'FoxcommerceOrderItem',
        'Attribute'      => 'FoxcommerceProductAttribute',
        'AttributeValue' => 'FoxcommerceProductAttributeValue'
    ];

    private static $cart_summary_id = 'Attribute.ID';

    private static $cart_summary = [
        'Attribute.ID'         => 'AttributeID',
        'AttributeValue.ID'    => 'ValueID',
        'Attribute.Title'      => 'AttributeLabel',
        'AttributeValue.Title' => 'ValueLabel',
    ];

    private static $cart_summary_relations = [
        //'cccAttributeValue' => 'ValueRelation'
    ];

    public function getTitle()
    {
        if (!$this->getIsComplete()) {
            return 'Broken Attribute Link';
        }

        return $this->OrderItem()->Product()->Title . ' ' . $this->Attribute()->Title . ' ' . $this->AttributeValue()->Title;
    }

    public function getIsComplete()
    {
        return ($this->OrderItemID && $this->AttributeID && $this->AttributeValueID);
    }

    /**
     * @return FoxcommerceProductAttribute
     */
    function Attribute()
    {
        return Versioned::get_version('FoxcommerceProductAttribute', $this->AttributeID, $this->AttributeVersionID);
    }

    /**
     * @return FoxcommerceProductAttribute
     */
    function AttributeValue()
    {
        return Versioned::get_version(
            'FoxcommerceProductAttributeValue',
            $this->AttributeValueID,
            $this->AttributeValueVersionID
        );
    }


    public function getAttributeTitle()
    {
        return $this->Attribute()->Title;
    }

    public function getDescription()
    {
        return ['label' => $this->Attribute()->Title, 'value' => $this->AttributeValue()];
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }
}