<?php


class FoxcommerceHelper
{

    public static function array_walk(array $array, $funcname, $userdata = null)
    {

        array_walk($array, $funcname, $userdata);

        return $array;
    }

    public static function array_except($array, $keys)
    {

        return array_diff_key($array, array_flip((array)$keys));
    }

    public static function array_only($array, $keys)
    {
        return array_intersect_key($array, array_flip((array)$keys));
    }

    public static function array_first($array)
    {
        $clone = $array;
        return array_shift($clone);
    }

    public static function array_last($array)
    {
        $clone = $array;
        return array_pop($clone);
    }

    public static function array_get($array, $key, $default = null)
    {
        if (is_null($key)) return $array;
        if (isset($array[$key])) return $array[$key];
        foreach (explode('.', $key) as $segment) {
            if (!is_array($array) || !array_key_exists($segment, $array)) {
                return $default;
            }
            $array = $array[$segment];
        }
        return $array;
    }

    public static function array_has($array, $key)
    {
        if (empty($array) || is_null($key)) return false;
        if (array_key_exists($key, $array)) return true;
        foreach (explode('.', $key) as $segment) {
            if (!is_array($array) || !array_key_exists($segment, $array)) {
                return false;
            }
            $array = $array[$segment];
        }
        return true;
    }

    public static function str_ends_with($haystack, $needles)
    {
        foreach ((array)$needles as $needle) {
            if ((string)$needle === substr($haystack, -strlen($needle))) {
                return true;
            }
        }
        return false;
    }

    public static function str_starts_with($haystack, $needles)
    {
        foreach ((array)$needles as $needle) {
            if ($needle != '' && strpos($haystack, $needle) === 0) {
                return true;
            }
        }
        return false;
    }

    public static function str_contains($haystack, $needles)
    {
        foreach ((array)$needles as $needle) {
            if ($needle != '' && strpos($haystack, $needle) !== false) {
                return true;
            }
        }
        return false;
    }

    public static function array_map_values($array)
    {
        $result = [];
        foreach ($array as $key => $value) {
            $result[is_numeric($key) ? $value : $key] = $value;
        }

        return $result;
    }

    public static function initial_state()
    {

        $order                              = FoxcommerceOrder::current();
        $state                              = $order->toNestedArray();
        $oldLocale                          = setlocale(LC_MONETARY, $order->current()->Country()->LocaleCode);
        $numberFormatInfo                   = localeconv();
        $numberFormatInfo['exchange_point'] = $order->Country()->Currency()->ExchangeRate;
        setlocale(LC_MONETARY, $oldLocale);

        $state['MetaData']['Currency'] = $numberFormatInfo;

        $additionalStateInformation = EventDispatcher::inst()->dispatch('updateCartInitialState', $state);
        foreach($additionalStateInformation as $addition){
            $state = array_merge_recursive($state, $addition);
        }

        return $state;

    }

    public static function build_cart_summary(DataObject $object)
    {
        $summary              = [];
        $cartSummaryFields    = $object->stat('cart_summary');
        $cartSummaryRelations = $object->stat('cart_summary_relations');

        if ($cartSummaryFields) {
            foreach (FoxcommerceHelper::array_map_values($cartSummaryFields) as $key => $title) {
                if ($object->hasField($key)) {
                    $summary[$title] = $object->getField($key);
                } elseif ($object->hasMethod($key)) {
                    $summary[$title] = $object->{$key}();
                } elseif ($object->relObject($key)) {
                    $summary[$title] = $object->relField($key);
                }
            }
        }

        if ($cartSummaryRelations) {
            foreach (FoxcommerceHelper::array_map_values($cartSummaryRelations) as $key => $title) {
                $summary[$title] = $object->{$key}();

                if (is_object($summary[$title]) && is_a($summary[$title], 'DataList')) {
                    $list = [];

                    /** @var DataObject $item */
                    foreach ($summary[$title] as $item) {
                        if ($item->stat('cart_summary_id')) {
                            if ($item->hasField($item->stat('cart_summary_id'))) {
                                $listKey = $item->{$item->stat('cart_summary_id')};
                            } elseif ($item->relObject($item->stat('cart_summary_id'))) {
                                $listKey = $item->relField($item->stat('cart_summary_id'));
                            }
                        } elseif ($item->hasMethod('getCartSummaryID')) {
                            $listKey = $item->getCartSummaryID();
                        } elseif ($item->hasMethod('CartSummaryID')) {
                            $listKey = $item->CartSummaryID();
                        }

                        if (isset($listKey)) {
                            $list[$listKey] = self::build_cart_summary($item);
                        } else {
                            $list[] = self::build_cart_summary($item);
                        }
                    }

                    $summary[$title] = $list;

                } elseif (is_object($summary[$title]) && is_a($summary[$title], 'DataObject')) {
                    $summary[$title] = self::build_cart_summary($summary[$title]);
                }
            }
        }

        $object->extend('updateCartSummary', $summary);

        return $summary;
    }

    public static function ruDebug($start)
    {
        $end = microtime(true);
        die("This process used " . (round(($end - $start), 4)) . " seconds for its computations");
    }

    public static function guid()
    {
        if (function_exists('com_create_guid') === true) {
            return trim(com_create_guid(), '{}');
        }

        $data    = openssl_random_pseudo_bytes(16);
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40); // set version to 0100
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80); // set bits 6-7 to 10
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    }

}