<?php

/**
 * Class FoxcommerceConfig
 *
 * @property string $TaxStyle
 * @property string $CheckoutCompleteMessage
 * @property string $EmailForAdminAddress
 * @property string $EmailForAdminSubject
 * @property string $EmailForAdminContent
 * @property string $EmailForCustomerSubject
 * @property string $ReplyToEmailForCustomer
 * @property string $FromEmailForCustomer
 * @property string $EmailForCustomerContent
 * @property int $FallbackCountryID
 * @method FoxcommerceCountry FallbackCountry()
 * @mixin FoxcommerceConfig_TaxExtension
 * @mixin FoxcommerceConfig_ContentExtension
 */
class FoxcommerceConfig extends DataObject
{

    protected static $db = [
    ];

    private static $has_one = [
        'FallbackCountry' => 'FoxcommerceCountry'
    ];

    protected static $disable_admin_tools = true;

    protected static $current;

    /**
     * @param bool $fetch
     * @return \FoxcommerceConfig
     */
    public static function current($fetch = false)
    {
        if ($fetch) {
            self::$current = null;
        }

        self::$current = self::$current ?: static::get_one(__CLASS__) ?: new static;;

        return self::$current;
    }

    public function requireDefaultRecords()
    {
        if (!self::current()) {
            /** @var self $config */
            $config = new self();
            $config->write();

            DB::alteration_message('Created default Ecommerce Configuration', 'created');
        }
    }

    public function canCreate($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canView($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canEdit($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

    public function canDelete($member = null)
    {
        return Permission::check('CMS_ACCESS_CMSMain', 'any', $member);
    }

}