<?php

class FoxcommerceLoginForm extends MemberLoginForm
{

    protected $login_action = 'account';

    /** @inheritdoc */
    public function __construct($controller, $name, $fields = null, $actions = null, $checkCurrentUser = true) {

        /** @var ContentController $controller */
        parent::__construct($controller, $name, $fields, $actions, $checkCurrentUser);
    }

    /** @inheritdoc */
    public function dologin($data)
    {
        if ($this->performLogin($data)) {
            $this->logInUserAndRedirect($data);
        } else {
            if (array_key_exists('Email', $data)) {
                Session::set('SessionForms.MemberLoginForm.Email', $data['Email']);
                Session::set('SessionForms.MemberLoginForm.Remember', isset($data['Remember']));
            }

            if (isset($_REQUEST['BackURL'])) {
                $backURL = $_REQUEST['BackURL'];
            } else $backURL = null;

            if ($backURL) Session::set('BackURL', $backURL);

            // Show the right tab on failed login
            $loginLink = Director::absoluteURL($this->controller->Link($this->login_action));
            if ($backURL) $loginLink .= '?BackURL=' . urlencode($backURL);
            $this->controller->redirect($loginLink);
        }
    }

    /** @inheritdoc */
    protected function logInUserAndRedirect($data)
    {
        Session::clear('SessionForms.MemberLoginForm.Email');
        Session::clear('SessionForms.MemberLoginForm.Remember');

        $order = FoxcommerceOrder::current();
        $order->MemberID = Member::currentUserID();
        $order->write();

        if (Member::currentUser()->isPasswordExpired()) {
            if (isset($_REQUEST['BackURL']) && $backURL = $_REQUEST['BackURL']) {
                Session::set('BackURL', $backURL);
            }
            $cp = new ChangePasswordForm($this->controller, 'ChangePasswordForm');
            $cp->sessionMessage(
                _t('Member.PASSWORDEXPIRED', 'Your password has expired. Please choose a new one.'),
                'good'
            );
            return $this->controller->redirect('Security/changepassword');
        }

        // Absolute redirection URLs may cause spoofing
        if (!empty($_REQUEST['BackURL'])) {
            $url = $_REQUEST['BackURL'];
            if (Director::is_site_url($url)) {
                $url = Director::absoluteURL($url);
            } else {
                // Spoofing attack, redirect to homepage instead of spoofing url
                $url = Director::absoluteBaseURL();
            }
            return $this->controller->redirect($url);
        }

        /** @var FoxcommerceCheckoutPage $page */
        $page = FoxcommerceCheckoutPage::get_one('FoxcommerceCheckoutPage');
        return $this->controller->redirect($page->Link());


    }


}