<?php

class ChangeCountryForm extends Form
{

    public function __construct(Controller $controller, $name = 'ChangeCountryForm')
    {

        $fields    = $this->getFormFields($controller);
        $actions   = $this->getFormActions($controller);
        $validator = $this->getFormValidator($controller);

        $this->extend('updateFormFields', $fields);
        $this->extend('updateFormActions', $actions);
        $this->extend('updateFormValidator', $validator);

        parent::__construct($controller, $name, $fields, $actions, $validator);

        $rules = Config::inst()->forClass('Director')->get('rules');
        $rules = array_flip($rules);

        $cart = FoxcommerceOrder::current();

        $this->setAttribute('data-current-country', $cart->Country()->Code);

        $this->disableSecurityToken();
        $this->addExtraClass('change-country-form');
        $this->setAttribute('data-hook', 'change-country-form');
        $this->setAttribute('data-bind', 'submit: changeCountry');
        $this->setFormAction(Controller::join_links(
            $rules['FoxcommerceCartController'],
            'changecountry'
        ));

        $this->extend('updateForm', $this);
    }

    public function getFormFields(Controller $controller)
    {

        $cart      = FoxcommerceOrder::current();
        $countries = FoxcommerceCountry::get('FoxcommerceCountry', ['Enabled' => true])->map('Code')->toArray();

        /** @var DropdownField $countryField */
        $countryField = DropdownField::create('Country', 'Country', $countries, $cart->Country()->Code);

        return FieldList::create(
            $countryField
        );
    }

    public function getFormActions(Controller $controller)
    {

        /** @var FormAction $addToCartAction */
        $addToCartAction = FormAction::create('changecountry', 'Change');
        return FieldList::create([$addToCartAction]);
    }

    public function getFormValidator(Controller $controller)
    {
        return RequiredFields::create();
    }

}