<?php

class CartFormItemRow extends FormField
{
    protected $template = '';

    protected $item;

    public function __construct(FoxcommerceOrderItem $item)
    {
        $this->item = $item;
        parent::__construct("CartItem[{$item->ID}]", $item->Product()->Title);
    }

    public function Item()
    {
        return $this->item;
    }


    public function FieldHolder($properties = array())
    {
        $context = $this;

        if (count($properties)) {
            $context = $this->customise($properties);
        }

        return $context->renderWith($this->getFieldHolderTemplates());
    }
}