<?php

class CartForm extends Form
{

    protected $template = 'CartForm';

    protected $itemFields;

    protected $modifierFields;

    protected $order;

    public function __construct(ContentController $controller, $name = 'CartForm')
    {

        $actions   = $this->getFormActions($controller);
        $validator = $this->getFormValidator($controller);

        $this->extend('updateFormActions', $actions);
        $this->extend('updateFormValidator', $validator);

        parent::__construct($controller, $name, FieldList::create(), $actions, $validator);

        $rules = Config::inst()->forClass('Director')->get('rules');
        $rules = array_flip($rules);

        /** @var FoxcommerceProduct $product */
        $product = $controller->data();

        $cart = FoxcommerceOrder::current();

        $this->disableSecurityToken();
        $this->addExtraClass('cart-form');
        $this->setAttribute('data-hook', 'cart-form');
        $this->extend('updateForm', $this);
    }

    public function Items()
    {

        $cart = FoxcommerceOrder::current();

        /** @var FieldList $items */
        $items = FieldList::create();

        foreach ($cart->Items() as $item) {
            $items->push(CartFormItemRow::create($item));
        }

        $this->extend('updateItems', $items);

        return $items;
    }

    public function getFormActions(ContentController $controller)
    {
        $list = new FieldList();

        /** @var FoxcommerceCartPage $cartPage */
        $cartPage = FoxcommerceCartPage::get_one('FoxcommerceCartPage');

        if($cartPage->ContinueShoppingPageID){
            $continueShoppingButton = FormAction::create('continueshopping', 'Continue Shopping')
                ->addExtraClass('foxcommerce-cart-form-continue-shopping-button');
            $list->push($continueShoppingButton);
        }

        /** @var FormAction $proceedToCheckoutButton */
        $proceedToCheckoutButton = FormAction::create('proceedtocheckout', 'Checkout')
            ->addExtraClass('foxcommerce-cart-form-checkout-button');
        $list->push($proceedToCheckoutButton);

        return $list;
    }

    public function getFormValidator(ContentController $controller)
    {
        return RequiredFields::create();
    }

    public function proceedtocheckout(){
        /** @var FoxcommerceCheckoutPage $checkoutPage */
        $checkoutPage = FoxcommerceCheckoutPage::get_one('FoxcommerceCheckoutPage');

        return $this->controller->redirect($checkoutPage->Link());
    }

}