<?php

class AddToCartForm extends Form
{

    public function __construct(FoxcommerceProduct_Controller $controller, $name = 'AddToCartForm')
    {

        $fields    = $this->getFormFields($controller);
        $actions   = $this->getFormActions($controller);
        $validator = $this->getFormValidator($controller);

        $this->extend('updateFormFields', $fields);
        $this->extend('updateFormActions', $actions);
        $this->extend('updateFormValidator', $validator);

        parent::__construct($controller, $name, $fields, $actions, $validator);

        $rules = Config::inst()->forClass('Director')->get('rules');
        $rules = array_flip($rules);

        /** @var FoxcommerceProduct $product */
        $product = $controller->data();

        $cart = FoxcommerceOrder::current();

        $itemInCart = $cart->exists() ? $cart->getItem(['ProductID' => $product->ID]) : false;
        $this->setAttribute('data-cart-quantity', $itemInCart ? $itemInCart->Quantity : 0);

        $this->disableSecurityToken();
        $this->addExtraClass('add-to-cart-form');
        $this->setAttribute('data-hook', 'add-to-cart-form');
        $this->setAttribute('data-bind', 'submit: updateCart');
        $this->setFormAction(Controller::join_links(
            $rules['FoxcommerceCartController'],
            'update'
        ));

        $this->extend('updateForm', $this);
    }

    public function getFormFields(FoxcommerceProduct_Controller $controller)
    {

        /** @var FoxcommerceProduct $product */
        $product = $controller->data();

        $cart = FoxcommerceOrder::current();

        $itemInCart = $cart->exists() ? $cart->getItem(['ProductID' => $product->ID]) : false;

        /** @var NumericField $quantityField */
        $quantityField = NumericField::create('Quantity', 'Quantity', $itemInCart ? $itemInCart->Quantity : 1);
        $quantityField->setAttribute('type', 'number');
        $quantityField->setAttribute('data-bind', 'textInput: quantityRequested');

        return FieldList::create(
            HiddenField::create('ProductID', null, $product->ID),
            $quantityField
        );
    }

    public function getFormActions(FoxcommerceProduct_Controller $controller)
    {

        /** @var FoxcommerceProduct $product */
        $product = $controller->data();

        $cart = FoxcommerceOrder::current();

        $itemInCart = $cart->exists() ? $cart->getItem(['ProductID' => $product->ID]) : false;

        $messages = [
            'add'    => _t('AddToCartForm.AddText', 'Add to cart'),
            'update' => _t('AddToCartForm.UpdateText', 'Update quantity'),
            'remove' => _t('AddToCartForm.RemoveText', 'Remove from cart'),
        ];


        /** @var FormAction $addToCartAction */
        $addToCartAction = FormAction::create('addtocart', $messages[$itemInCart ? 'update' : 'add']);
        $addToCartAction->setAttribute('data-bind', 'value: buttonText, enable: buttonEnabled');
        $addToCartAction->setAttribute('data-text-add', $messages['add']);
        $addToCartAction->setAttribute('data-text-update', $messages['update']);
        $addToCartAction->setAttribute('data-text-remove', $messages['remove']);
        $addToCartAction->setDisabled(true);
        return FieldList::create([$addToCartAction]);
    }

    public function getFormValidator(FoxcommerceProduct_Controller $controller)
    {
        return RequiredFields::create();
    }

}