<?php

/**
 * Created by PhpStorm.
 * User: matthew
 * Date: 23/09/16
 * Time: 10:25 AM
 */
class FoxcommerceChangePasswordForm extends Form
{

    protected static $allowed_actions = [
        'submit'
    ];

    public function __construct($controller, $name)
    {
        $fields = $this->getFields();
        parent::__construct($controller, $name, $fields, $this->getActions());

        $this->extend('updateFields', $fields);

    }

    public function getFields()
    {
        $fields = FieldList::create([
            PasswordField::create("OldPassword", _t('Member.YOUROLDPASSWORD', "Your old password")),
            PasswordField::create("NewPassword1", _t('Member.NEWPASSWORD', "New Password")),
            PasswordField::create("NewPassword2", _t('Member.CONFIRMNEWPASSWORD', "Confirm New Password"))
        ]);


        return $fields;

    }

    public function getActions()
    {

        $actions = FieldList::create([
            FormAction::create("submit", _t('Member.BUTTONCHANGEPASSWORD', "Change Password"))
        ]);

        $this->extend('updateActions', $actions);

        return $actions;
    }


    public function submit($data, FoxcommerceChangePasswordForm $form, SS_HTTPRequest $request)
    {
        $member = Member::currentUser();
        // The user was logged in, check the current password
        if (empty($data['OldPassword']) || !$member->checkPassword($data['OldPassword'])->valid()) {
            $this->clearMessage();
            $this->sessionMessage(_t('Member.ERRORPASSWORDNOTMATCH', "Your current password does not match, please try again"), "bad");
            return $this->controller->redirectBack();
        }

        // Check the new password
        if (empty($data['NewPassword1'])) {
            $this->clearMessage();
            $this->sessionMessage(_t('Member.EMPTYNEWPASSWORD', "The new password can't be empty, please try again"), "bad");
            return $this->controller->redirectBack();
        } else if ($data['NewPassword1'] == $data['NewPassword2']) {
            $isValid = $member->changePassword($data['NewPassword1']);
            if ($isValid->valid()) {

                $this->sessionMessage('Your password has been changed successfully', 'good');

                // Clear locked out status
                $member->LockedOutUntil   = null;
                $member->FailedLoginCount = null;
                $member->write();

                return $this->controller->redirectBack();

            } else {
                $this->clearMessage();
                $this->sessionMessage(
                    _t(
                        'Member.INVALIDNEWPASSWORD',
                        "We couldn't accept that password: {password}",
                        array('password' => nl2br("\n" . Convert::raw2xml($isValid->starredList())))
                    ),
                    "bad",
                    false
                );

                return $this->controller->redirectBack();
            }

        } else {
            $this->clearMessage();
            $this->sessionMessage(_t('Member.ERRORNEWPASSWORD', "You have entered your new password differently, try again"), "bad");

            return $this->controller->redirectBack();
        }
    }

}

