<?php

class FoxcommerceAccountDetailsForm extends Form
{

    protected static $allowed_actions = [
        'submit'
    ];

    public function __construct(Controller $controller, $name)
    {

        $validator = new RequiredFields($this->getRequiredFields());

        parent::__construct($controller, $name, $fields = $this->getFields(), $actions = $this->getActions(), $validator);

        $this->extend('updateFields', $fields);
        $this->extend('updateActions', $actions);
        $this->extend('updateRequiredFields', $fields);

        $this->loadDataFrom(Member::currentUser());
    }

    public function getRequiredFields()
    {

        return ['FirstName', 'Surname', 'Email'];
    }

    protected function getFields()
    {
        $fields = FieldList::create([
            TextField::create('FirstName'),
            TextField::create('Surname'),
            EmailField::create('Email')
        ]);

        return $fields;
    }

    protected function getActions()
    {

        $actions = FieldList::create([
            FormAction::create('submit', 'Save Changes')
        ]);

        return $actions;
    }

    public function submit($data, FoxcommerceAccountDetailsForm $form, SS_HTTPRequest $request)
    {
        $this->sessionMessage('Your details have been updated successfully', 'good');
        $member = Member::currentUser();

        $form->saveInto($member);

        $member->write();

        return $this->controller->redirectBack();
    }


}