<?php

/**
 * Class MaximumQuantityRestrictedProductExtension
 *
 * @property FoxcommerceProduct|MaximumQuantityRestrictedProductExtension $owner
 * @property int $MaximumPurchasableQuantity
 */
class MaximumQuantityRestrictedProductExtension extends SiteTreeExtension
{
    private static $db = [
        'MaximumPurchasableQuantity' => 'Int'
    ];

    private static $defaults = [
        'MaximumPurchasableQuantity' => 0
    ];

    private static $cart_summary = [
        'MaximumPurchasableQuantity'
    ];

    public function updateCMSFields(FieldList $fields)
    {
        $fields->insertAfter(
            'ItemPrice',
            NumericField::create('MaximumPurchasableQuantity', 'Maximum Purchasable')
                        ->setDescription('-1 to disable purchase, 0 for unlimited, 1 to hide quantity field, or any other number to restrict the quantity')
        );
    }


}