<?php

/**
 * Class Foxcommerce_PaymentExtension
 *
 * @property Payment|Foxcommerce_PaymentExtension $owner
 * @property int $FoxcommerceOrderID
 * @method FoxcommerceOrder FoxcommerceOrder()
 */
class Foxcommerce_PaymentExtension extends DataExtension
{

    private static $has_one = [
        'FoxcommerceOrder' => 'FoxcommerceOrder'
    ];

    public function onCaptured($response)
    {
        /** @var FoxcommerceOrder $order */
        $order = $this->owner->FoxcommerceOrder();
        if ($order) {
            FoxcommerceOrder::setCurrent($order);
            $steps = array_keys(Config::inst()->get('CheckoutProcess', 'steps'));
            /** @var CheckoutStep $stepClass */
            foreach($steps as $stepClass){
                $stepClass::onPaymentComplete($order);
            }
            $order->extend('onPaymentReceived', $order);
        }
    }

}