<?php

class Foxcommerce_OrderCompleteEmailsExtension extends DataExtension
{
    public function onPaymentReceived(FoxcommerceOrder $order){
        $this->sendEmailToCustomer($order);
        $this->sendEmailToAdmin($order);
    }

    private function sendEmailToCustomer(FoxcommerceOrder $order)
    {
        $email = new Email();
        $email->setTemplate('FoxcommerceOrderCompleteForCustomer');
        $email->setFrom(FoxcommerceConfig::current()->FromEmailForCustomer);
        $email->setTo($order->CustomerEmail);
        $email->setSubject(FoxcommerceConfig::current()->EmailForCustomerSubject);
        $email->populateTemplate([
            'Order'   => $order,
            'Content' => FoxcommerceConfig::current()->EmailForCustomerContent
        ]);
        $email->send();
    }

    private function sendEmailToAdmin(FoxcommerceOrder $order)
    {
        $email = new Email();
        $email->setTemplate('FoxcommerceOrderCompleteForAdmin');
        $email->setFrom(FoxcommerceConfig::current()->FromEmailForCustomer);
        $email->setTo(FoxcommerceConfig::current()->EmailForAdminAddress);
        $email->setSubject(FoxcommerceConfig::current()->EmailForAdminSubject);
        $email->populateTemplate([
            'Order'   => $order,
            'Content' => FoxcommerceConfig::current()->EmailForAdminContent
        ]);
        $email->send();
    }

}