<?php

/**
 * Class Foxcommerce_MemberExtension
 *
 * @property Member|Foxcommerce_MemberExtension $owner
 * @method DataList|FoxcommerceAddress[] FoxcommerceAddresses()
 * @method DataList|FoxcommerceOrder[] FoxcommerceOrders()
 */
class Foxcommerce_MemberExtension extends DataExtension
{
    protected static $login_cart_session;

    protected static $has_many = [
        'FoxcommerceAddresses' => 'FoxcommerceAddress',
        'FoxcommerceOrders'    => 'FoxcommerceOrder'
    ];

    public function updateCMSFields(FieldList $fields)
    {
        $fields->removeByName('FoxcommerceAddresses');
        $fields->removeByName('FoxcommerceOrders');

        $gridfieldConfig = new GridFieldConfig_RecordEditor();

        $fields->addFieldToTab('Root.Shop.PreviousOrders',
            GridField::create('FoxcommerceOrders', 'Previous Orders', $this->owner->FoxcommerceOrders(), $gridfieldConfig)
        );

        $gridfieldConfig = new GridFieldConfig_RecordEditor();

        $fields->addFieldToTab('Root.Shop.Addresses',
            GridField::create('FoxcommerceAddresses', 'Addresses', $this->owner->AllAddresses(true), $gridfieldConfig)
        );
    }

    public function BillingAddresses($includeArchived = false)
    {
        return $this->owner->AllAddresses($includeArchived)->filter('Usage', ['Both', 'Billing']);
    }

    public function ShippingAddresses($includeArchived = false)
    {
        return $this->owner->AllAddresses($includeArchived)->filter('Usage', ['Both', 'Shipping']);
    }

    public function AllAddresses($includeArchived = false)
    {
        $addresses = $this->owner->FoxcommerceAddresses();
        return ($includeArchived ? $addresses : $addresses->exclude(['Archived' => true]));
    }

    public function DefaultBillingAddress()
    {
        return $this->owner->BillingAddresses()->filter(['DefaultForBilling' => true])->first();
    }

    public function DefaultShippingAddress()
    {
        return $this->owner->ShippingAddresses()->filter(['DefaultForShipping' => true])->first();
    }

    public function beforeMemberLoggedIn()
    {
        $cart = FoxcommerceOrder::current();
        if ($cart->exists()) {
            self::$login_cart_session = $cart->SessionID;
        }
    }

    public function memberLoggedIn()
    {
        if (self::$login_cart_session) {
            /** @var FoxcommerceOrder $cart */
            $cart         = FoxcommerceOrder::get()->filter(['SessionID' => self::$login_cart_session])->first();
            $newSessionID = FoxcommerceHelper::guid();
            Session::set('order-guid', $newSessionID);
            $cart->SessionID = $newSessionID;
            $cart->MemberID  = $this->owner->ID;
            $cart->write();

            FoxcommerceOrder::setCurrent($cart);
        }
    }
}