<?php


class FixedDecimal extends DBField
{

    protected $wholeSize, $decimalSize, $defaultValue;

    /**
     * Create a new Decimal field.
     *
     * @param string $name
     * @param string $defaultValue
     */
    public function __construct($name = null, $defaultValue = "0")
    {
        $this->wholeSize   = 19;
        $this->decimalSize = 4;

        $this->defaultValue = $defaultValue;

        parent::__construct($name);
    }

    public function getValue()
    {
        return (string)$this->value ?: "0";
    }

    public function requireField()
    {
        $parts = array(
            'datatype'   => 'decimal',
            'precision'  => "$this->wholeSize,$this->decimalSize",
            'default'    => $this->defaultValue,
            'arrayValue' => $this->arrayValue
        );

        $values = array(
            'type'  => 'decimal',
            'parts' => $parts
        );

        DB::require_field($this->tableName, $this->name, $values);
    }

    /**
     * @param DataObject $dataObject
     */
    public function saveInto($dataObject)
    {
        $fieldName = $this->name;

        if ($fieldName) {
            $dataObject->$fieldName = preg_replace('/[^0-9.\-\+]/', '', $this->value);
        } else {
            user_error("DBField::saveInto() Called on a nameless '" . get_class($this) . "' object", E_USER_ERROR);
        }
    }

    /**
     * @param string $title
     * @param array  $params
     *
     * @return NumericField
     */
    public function scaffoldFormField($title = null, $params = null)
    {
        return new TextField($this->name, $title);
    }

    /**
     * @return float
     */
    public function nullValue()
    {
        return "0.00";
    }

    public function prepValueForDB($value)
    {
        if ($value === true) {
            $value = "1";
        } elseif (empty($value) || !is_numeric($value)) {
            $value = "0";
        }

//        $value = explode('.', $value);
//        $int =

        return $value;
    }
}