<?php

class CheckoutStepReviewBeforePayment extends CheckoutStep
{

    public function FormFields(Controller $controller = null)
    {
        return new FieldList([
            HeaderField::create('ReviewDetails', 'Your Details', 3),
            LiteralField::create('NonEditableDetails', SSViewer::execute_template('StaticCheckoutDetails', new ArrayData([
                'Order' => $this->currentOrder
            ]))),
            HeaderField::create('ReviewAddress', 'Your Address', 3),
            LiteralField::create('NonEditableAddress', SSViewer::execute_template('StaticCheckoutAddress', new ArrayData([
                'Order' => $this->currentOrder
            ]))),
            HeaderField::create('ReviewCart', 'Your Cart', 3),
            LiteralField::create('NonEditableCart', SSViewer::execute_template('StaticCartForm', [])),
            HeaderField::create('ReviewPayment', 'Payment Information', 3),
            LiteralField::create('RedirectToHostedPaymentGatewayMessage', SSViewer::execute_template('RedirectToHostedPaymentGatewayMessage', [])),
        ]);
    }

    public function handleSubmission(array $data, CheckoutForm $form, SS_HTTPRequest $request = null)
    {
        return true;
    }

    public function hasBeenPassed()
    {
        return true;
    }

}