<?php

use SilverStripe\Omnipay\GatewayInfo as PaymentGatewayInfo;
use SilverStripe\Omnipay\Service\ServiceFactory as PaymentServiceFactory;

class CheckoutStepPaymentProcessing extends CheckoutStep
{

    public function init()
    {
        //If we have no payment gateway we shouldn't be here
        if (!$this->gatewayFactory()) return false;

        if ($this->currentOrder->getIsPaid()) {
            return 'advance';
        }

        $paymentGateway = $this->currentOrder->PaymentGateway;
        if (PaymentGatewayInfo::isOffsite($paymentGateway)) {
            $payment = $this->getPayment();

            switch(strtolower(FoxcommerceHelper::array_get(self::config(), 'intent', 'payment'))) {
                case 'payment':
                    $intent = PaymentServiceFactory::INTENT_PAYMENT;
                    break;
                case 'authorize':
                    $intent = PaymentServiceFactory::INTENT_AUTHORIZE;
                    break;
                default:
                    throw new Exception('Unknown payment intent passed');
            }

            $response = PaymentServiceFactory::create()
                ->getService($payment, $intent)
                ->initiate($this->currentOrder->paymentFields());

            return $response->redirectOrRespond();
        }

        //todo: Handle onSite payment gateways
    }

    public function FormFields(Controller $controller = null)
    {
        return new FieldList();
    }

    public function Validator()
    {
        //If we have no payment gateway we shouldn't be here, but we'll return an empty validator just to be safe
        if (!$this->gatewayFactory()) return parent::Validator();

        $fields = \SilverStripe\Omnipay\GatewayInfo::requiredFields($this->currentOrder->PaymentGateway);
        return new RequiredFields($fields);
    }

    public function handleSubmission(array $data, CheckoutForm $form, SS_HTTPRequest $request = null)
    {
        return true;
    }

    public function hasBeenPassed()
    {
        return $this->currentOrder->getIsPaid();
    }

    protected function gatewayFactory()
    {
        if (!$this->currentOrder->PaymentGateway) return false;
        return new SilverStripe\Omnipay\GatewayFieldsFactory($this->currentOrder->PaymentGateway);
    }

    protected function availableGateways()
    {
        return \SilverStripe\Omnipay\GatewayInfo::getSupportedGateways();
    }

    protected function getPayment()
    {
        $paymentGateway  = $this->currentOrder->PaymentGateway;
        $paymentCurrency = FoxcommerceCurrency::baseCurrency()->Code;
        $paymentTotal    = sprintf("%.2f", $this->currentOrder->Total);

        $payment = Payment::get()->filter(['FoxcommerceOrderID' => $this->currentOrder->ID, 'Status' => 'Created'])->first()
            ?: Payment::create(['FoxcommerceOrderID' => $this->currentOrder->ID]);

        //We can do this here as the checkout process gets instantiated earlier on
        $urlSegment = CheckoutProcess::stepList()[__CLASS__]['url_segment'];
        $link       = FoxcommerceCheckoutPage::get_one('FoxcommerceCheckoutPage')->Link(Controller::join_links($urlSegment, 'complete', $this->currentOrder->ID));

        $payment
            ->init($paymentGateway, $paymentTotal, $paymentCurrency)
            ->setSuccessUrl($link . '?state=success')
            ->setFailureUrl($link . '?state=errored');

        $payment->write();

        return $payment;
    }

    public function visibleInStepList()
    {
        return count($this->availableGateways()) !== 0;
    }
}