<?php

class CheckoutStepPaymentMethodSelection extends CheckoutStep
{

    public function FormFields(Controller $controller = null)
    {
        $fields         = new FieldList();
        $currentGateway = $this->currentOrder->PaymentGateway;
        $fields->push(new OptionsetField('PaymentGateway', 'Payment Method', $this->availableGateways(), $currentGateway));

        return $fields;
    }

    public function Validator()
    {
        return new RequiredFields(['PaymentGateway']);
    }

    public function handleSubmission(array $data, CheckoutForm $form, SS_HTTPRequest $request = null)
    {
        $this->currentOrder->PaymentGateway = $data['PaymentGateway'];
        $this->currentOrder->write();
        return true;
    }

    public function hasBeenPassed()
    {
        $gateway = $this->currentOrder->PaymentGateway;
        return !empty($gateway) && array_key_exists($gateway, $this->availableGateways());
    }

    public static function extraStatics()
    {
        return [
            'db' => [
                'PaymentGateway' => 'Varchar(255)'
            ],
            'export_columns' => [
                'PaymentGateway' => 'Payment Gateway'
            ]
        ];
    }

    public function onAdvance(CheckoutForm $form)
    {
        if (count($this->availableGateways()) === 0) {
            $this->currentOrder->PaymentGateway = 'Offline';
            $form->sessionMessage('Payment for this order will be handled offline', 'offline');
            $this->currentOrder->write();
        } elseif (!$this->visibleInStepList()) {
            $keys                               = array_keys($this->availableGateways());
            $this->currentOrder->PaymentGateway = array_shift($keys);
            $this->currentOrder->write();
        }
    }

    protected function availableGateways()
    {
        return \SilverStripe\Omnipay\GatewayInfo::getSupportedGateways();
    }

    public function visibleInStepList()
    {
        return count($this->availableGateways()) > 1;
    }
}