<?php

class CheckoutStepCustomerAddressShippingAndBilling extends CheckoutStep
{

    public function FormFields(Controller $controller = null)
    {

        $member = Member::currentUser();
        if (!$member) {
            $this->addCheckboxToggleJavascript();

            $assume_same = FoxcommerceHelper::array_get(self::config(), 'assume_same', false);
            $order       = $this->currentOrder;

            if ($order->ShippingAddressLine1 && ($order->ShippingAddressLine1 === $order->BillingAddressLine1)) {
                $assume_same = true;
            }

            return new FieldList([
                FieldGroup::create('Shipping Address', $this->anonymousShippingFields())->addExtraClass('shipping-address'),
                CheckboxField::create('ShippingAndBillingAddressEqual', 'My shipping and billing address are the same', $assume_same),
                FieldGroup::create('Billing Address', $this->anonymousBillingFields())
                    ->addExtraClass('billing-address')->addExtraClass(($assume_same ? 'hidden' : '')),
            ]);
        } else {
            /** @var HasManyList $billingAddresses */
            $billingAddresses = $member->BillingAddresses();
            /** @var HasManyList $shippingAddresses */
            $shippingAddresses = $member->ShippingAddresses();

            /** @var FoxcommerceAccountPage $accountPage */
            $accountPage = FoxcommerceAccountPage::get_one('FoxcommerceAccountPage');

            if ($billingAddresses->count() && $shippingAddresses->count()) {
                return new FieldList([
                    OptionsetField::create('BillingAddressForOrder', 'Billing Address', $billingAddresses->Map(), $billingAddresses->first()->ID),
                    OptionsetField::create('ShippingAddressForOrder', 'Shipping Address', $shippingAddresses->Map(), $shippingAddresses->first()->ID),
                    LiteralField::create('AddressLoadedFromDB', '
                        <div class="message info">
                            <strong>We\'ve loaded your existing address details from your account.</strong>
                            <p><a href="'.$accountPage->Link().'" class="update-details">Update your address details on your account</a></p>
                        </div>
                    ')
                ]);
            } else {
                return new FieldList([
                    LiteralField::create('NoAddressWarning', '
                        <div class="message bad">
                            <strong>It looks like the address information stored on your account isn\'t quite right.</strong>
                            <p><a href="/account/addresses" class="update-details">Update your address details here</a></p>
                        </div>
                    ')
                ]);
            }
        }
    }

    public function handleSubmission(array $data, CheckoutForm $form, SS_HTTPRequest $request = null)
    {
        $order = $this->currentOrder;
        if (Member::currentUser()) {
            $order->ShippingAddressForMemberID = $data['ShippingAddressForOrder'];
            $order->BillingAddressForMemberID  = $data['BillingAddressForOrder'];
            /** @var FoxcommerceAddress $shippingAddress */
            $shippingAddress = FoxcommerceAddress::get_one('FoxcommerceAddress', ['ID' => $order->ShippingAddressForMemberID]);
            /** @var FoxcommerceAddress $billingAddress */
            $billingAddress = FoxcommerceAddress::get_one('FoxcommerceAddress', ['ID' => $order->BillingAddressForMemberID]);

            $order->ShippingAddressLine1    = $shippingAddress->AddressLine1;
            $order->ShippingAddressLine2    = $shippingAddress->AddressLine2;
            $order->ShippingAddressSuburb   = $shippingAddress->Suburb;
            $order->ShippingAddressRegion   = $shippingAddress->Region;
            $order->ShippingAddressPostcode = $shippingAddress->Postcode;
            $order->ShippingAddressCountry  = $shippingAddress->Country;
            $order->BillingAddressLine1     = $billingAddress->AddressLine1;
            $order->BillingAddressLine2     = $billingAddress->AddressLine2;
            $order->BillingAddressSuburb    = $billingAddress->Suburb;
            $order->BillingAddressRegion    = $billingAddress->Region;
            $order->BillingAddressPostcode  = $billingAddress->Postcode;
            $order->BillingAddressCountry   = $billingAddress->Country;
        } else {
            if ($data['ShippingAndBillingAddressEqual']) {
                $order->ShippingAddressLine1    = $order->BillingAddressLine1 = $data['ShippingAddressLine1'];
                $order->ShippingAddressLine2    = $order->BillingAddressLine2 = $data['ShippingAddressLine2'];
                $order->ShippingAddressSuburb   = $order->BillingAddressSuburb = $data['ShippingAddressSuburb'];
                $order->ShippingAddressRegion   = $order->BillingAddressRegion = $data['ShippingAddressRegion'];
                $order->ShippingAddressPostcode = $order->BillingAddressPostcode = $data['ShippingAddressPostcode'];
                $order->ShippingAddressCountry  = $order->BillingAddressCountry = $data['ShippingAddressCountry'];
            } else {
                $order->ShippingAddressLine1    = $data['ShippingAddressLine1'];
                $order->ShippingAddressLine2    = $data['ShippingAddressLine2'];
                $order->ShippingAddressSuburb   = $data['ShippingAddressSuburb'];
                $order->ShippingAddressRegion   = $data['ShippingAddressRegion'];
                $order->ShippingAddressPostcode = $data['ShippingAddressPostcode'];
                $order->ShippingAddressCountry  = $data['ShippingAddressCountry'];
                $order->BillingAddressLine1     = $data['BillingAddressLine1'];
                $order->BillingAddressLine2     = $data['BillingAddressLine2'];
                $order->BillingAddressSuburb    = $data['BillingAddressSuburb'];
                $order->BillingAddressRegion    = $data['BillingAddressRegion'];
                $order->BillingAddressPostcode  = $data['BillingAddressPostcode'];
                $order->BillingAddressCountry   = $data['BillingAddressCountry'];
            }
        }
        $order->write();
        return true;
    }

    public function hasBeenPassed()
    {
        $member = Member::currentUser();
        $order  = $this->currentOrder;
        if ($member) {
            return (
                $order->ShippingAddressForMember()->exists() &&
                $order->BillingAddressForMember()->exists()
            );
        } else {
            return (
                $order->ShippingAddressLine1 &&
                $order->ShippingAddressSuburb &&
                $order->ShippingAddressRegion &&
                $order->ShippingAddressPostcode &&
                $order->ShippingAddressCountry &&
                $order->BillingAddressLine1 &&
                $order->BillingAddressSuburb &&
                $order->BillingAddressRegion &&
                $order->BillingAddressPostcode &&
                $order->BillingAddressCountry
            );
        }
    }

    public function Validator()
    {
        return new CheckoutStepCustomerAddressShippingAndBillingValidator([]);
    }

    protected function anonymousShippingFields()
    {
        $order = $this->currentOrder;

        return [
            TextField::create('ShippingAddressLine1', 'Address Line 1', $order->ShippingAddressLine1)->setAttribute('data-address-required-type', 'shipping'),
            TextField::create('ShippingAddressLine2', 'Address Line 2', $order->ShippingAddressLine2)->setAttribute('data-address-required-type', 'none'),
            TextField::create('ShippingAddressSuburb', 'Suburb', $order->ShippingAddressSuburb)->setAttribute('data-address-required-type', 'shipping'),
            TextField::create('ShippingAddressRegion', 'Region', $order->ShippingAddressRegion)->setAttribute('data-address-required-type', 'shipping'),
            TextField::create('ShippingAddressPostcode', 'Postcode', $order->ShippingAddressPostcode)->setAttribute('data-address-required-type', 'shipping'),
            CountryDropdownField::create('ShippingAddressCountry', 'Country', $order->ShippingAddressCountry)->setAttribute('data-address-required-type', 'shipping'),
        ];
    }

    protected function anonymousBillingFields()
    {
        $order = $this->currentOrder;

        //here we just fudge the reference order to an empty order so the below fields just pull empty values
        if ($order->ShippingAddressLine1 && ($order->ShippingAddressLine1 === $order->BillingAddressLine1)) {
            $order = new FoxcommerceOrder();
        }

        return [
            TextField::create('BillingAddressLine1', 'Address Line 1', $order->BillingAddressLine1)->setAttribute('data-address-required-type', 'billing'),
            TextField::create('BillingAddressLine2', 'Address Line 2', $order->BillingAddressLine2)->setAttribute('data-address-required-type', 'none'),
            TextField::create('BillingAddressSuburb', 'Suburb', $order->BillingAddressSuburb)->setAttribute('data-address-required-type', 'billing'),
            TextField::create('BillingAddressRegion', 'Region', $order->BillingAddressRegion)->setAttribute('data-address-required-type', 'billing'),
            TextField::create('BillingAddressPostcode', 'Postcode', $order->BillingAddressPostcode)->setAttribute('data-address-required-type', 'billing'),
            CountryDropdownField::create('BillingAddressCountry', 'Country', $order->BillingAddressCountry)->setAttribute('data-address-required-type', 'billing'),
        ];
    }

    public static function extraStatics()
    {
        return [
            'db'             => [
                'ShippingAddressLine1'    => 'Varchar(255)',
                'ShippingAddressLine2'    => 'Varchar(255)',
                'ShippingAddressSuburb'   => 'Varchar(255)',
                'ShippingAddressRegion'   => 'Varchar(255)',
                'ShippingAddressPostcode' => 'Varchar(255)',
                'ShippingAddressCountry'  => 'Varchar(255)',
                'BillingAddressLine1'     => 'Varchar(255)',
                'BillingAddressLine2'     => 'Varchar(255)',
                'BillingAddressSuburb'    => 'Varchar(255)',
                'BillingAddressRegion'    => 'Varchar(255)',
                'BillingAddressPostcode'  => 'Varchar(255)',
                'BillingAddressCountry'   => 'Varchar(255)',
            ],
            'export_columns' => [
                'ShippingAddressLine1'    => 'Shipping Address Line 1',
                'ShippingAddressLine2'    => 'Shipping Address Line 2',
                'ShippingAddressSuburb'   => 'Shipping Address Suburb',
                'ShippingAddressRegion'   => 'Shipping Address Region',
                'ShippingAddressPostcode' => 'Shipping Address Postcode',
                'ShippingAddressCountry'  => 'Shipping Address Country',
                'BillingAddressLine1'     => 'Billing Address Line 1',
                'BillingAddressLine2'     => 'Billing Address Line 2',
                'BillingAddressSuburb'    => 'Billing Address Suburb',
                'BillingAddressRegion'    => 'Billing Address Region',
                'BillingAddressPostcode'  => 'Billing Address Postcode',
                'BillingAddressCountry'   => 'Billing Address Country'
            ],
            'has_one'        => [
                'BillingAddressForMember'  => 'FoxcommerceAddress',
                'ShippingAddressForMember' => 'FoxcommerceAddress',
            ],
            'payment_fields' => [
                'billingAddress1'  => 'BillingAddressLine1',
                'billingAddress2'  => 'BillingAddressLine2',
                'billingCity'      => 'BillingAddressSuburb',
                'billingPostcode'  => 'BillingAddressPostcode',
                'billingState'     => 'BillingAddressRegion',
                'billingCountry'   => 'BillingAddressCountry',
                'shippingAddress1' => 'ShippingAddressLine1',
                'shippingAddress2' => 'ShippingAddressLine2',
                'shippingCity'     => 'ShippingAddressSuburb',
                'shippingPostcode' => 'ShippingAddressPostcode',
                'shippingState'    => 'ShippingAddressRegion',
                'shippingCountry'  => 'ShippingAddressCountry',
            ]
        ];
    }

    protected function addCheckboxToggleJavascript()
    {
        Requirements::customScript(
        /** @lang JavaScript */
            <<<SCRIPT
(function() {
    var checkbox = document.querySelector('input[name="ShippingAndBillingAddressEqual"]');
    var billingAddressFieldSet = document.querySelector('.billing-address');
    var billingRequiredFields = document.querySelectorAll('[data-address-required-type="billing"]');
    function setBillingState(){ 
        if(checkbox.checked){
            billingAddressFieldSet.classList.add('hidden');
            for (i = 0; i < billingRequiredFields.length; ++i) {
                billingRequiredFields[i].removeAttribute('required');
            }
        } else {
            billingAddressFieldSet.classList.remove('hidden');
            for (i = 0; i < billingRequiredFields.length; ++i) {
                billingRequiredFields[i].setAttribute('required', 'required');
            }
        }
    }
    
    checkbox.addEventListener('change', setBillingState);
    setBillingState();
})();
SCRIPT
        );
    }

    public static function onPaymentComplete(FoxcommerceOrder $order)
    {
        if (!$order->MemberID || $order->ShippingAddressForMemberID || $order->BillingAddressForMemberID) return;

        $singleAddress = ($order->ShippingAddressLine1 === $order->BillingAddressLine1);

        $shippingAddress                     = new FoxcommerceAddress;
        $shippingAddress->MemberID           = $order->MemberID;
        $shippingAddress->AddressLine1       = $order->ShippingAddressLine1;
        $shippingAddress->AddressLine2       = $order->ShippingAddressLine2;
        $shippingAddress->Suburb             = $order->ShippingAddressSuburb;
        $shippingAddress->Postcode           = $order->ShippingAddressPostcode;
        $shippingAddress->Region             = $order->ShippingAddressRegion;
        $shippingAddress->DefaultForShipping = true;
        $shippingAddress->DefaultForBilling  = $singleAddress;
        $shippingAddress->write();

        $order->ShippingAddressForMemberID = $shippingAddress->ID;
        $order->BillingAddressForMemberID  = $shippingAddress->ID;

        if (!$singleAddress) {
            $billingAddress                    = new FoxcommerceAddress;
            $billingAddress->MemberID          = $order->MemberID;
            $billingAddress->AddressLine1      = $order->BillingAddressLine1;
            $billingAddress->AddressLine2      = $order->BillingAddressLine2;
            $billingAddress->Suburb            = $order->BillingAddressSuburb;
            $billingAddress->Postcode          = $order->BillingAddressPostcode;
            $billingAddress->Region            = $order->BillingAddressRegion;
            $billingAddress->DefaultForBilling = true;
            $billingAddress->write();

            $order->BillingAddressForMemberID = $billingAddress->ID;
        }

        $order->write();
    }
}

class CheckoutStepCustomerAddressShippingAndBillingValidator extends RequiredFields
{

    public function php($data)
    {
        if (Member::currentUser()) {
            $this->addRequiredField('BillingAddressForMember');
            $this->addRequiredField('ShippingAddressForMember');
        } else {
            $this->addRequiredField('ShippingAddressLine1');
            $this->addRequiredField('ShippingAddressSuburb');
            $this->addRequiredField('ShippingAddressRegion');
            $this->addRequiredField('ShippingAddressPostcode');
            $this->addRequiredField('ShippingAddressCountry');

            if (!$data['ShippingAndBillingAddressEqual']) {
                $this->addRequiredField('BillingAddressLine1');
                $this->addRequiredField('BillingAddressSuburb');
                $this->addRequiredField('BillingAddressRegion');
                $this->addRequiredField('BillingAddressPostcode');
                $this->addRequiredField('BillingAddressCountry');
            }
        }

        return parent::php($data);
    }

}