<?php

class CheckoutStepComplete extends CheckoutStep
{

    public function init()
    {
        $autoLogin = FoxcommerceHelper::array_get(self::config(), 'auto_login', false);
        if ($this->currentOrder->MemberID && $autoLogin) {
            $member = $this->currentOrder->Member();
            $member->logIn(true);
        }
        $this->currentOrder->close();
    }

    public function FormFields(Controller $controller = null)
    {
        /** @var HTMLText $message */
        $message = FoxcommerceConfig::current()->dbObject('CheckoutCompleteMessage');
        $message = $message->setProcessShortcodes(true);
    
        return new FieldList([
            LiteralField::create('FoxcommerceOrderComplete', SSViewer::execute_template('FoxcommerceOrderComplete', new ArrayData([
                'Content'        => $message,
                'CompletedOrder' => $this->currentOrder,
                'LoggedIn'       => FoxcommerceHelper::array_get(self::config(), 'auto_login', false)
            ]))),
        ]);
    }

    public function handleSubmission(array $data, CheckoutForm $form, SS_HTTPRequest $request = null)
    {
        return true;
    }

    public function hasBeenPassed()
    {
        return false;
    }

}