<?php

class CheckoutForm extends Form
{

    protected $allowed_actions = [
        'previousstep',
        'nextstep'
    ];

    protected $process;

    protected $step;

    public function __construct(CheckoutProcess $process, CheckoutStep $step, Controller $controller)
    {
        $this->process = $process;
        $this->step    = $step;
        $this->controller = $controller;

        $fields        = $step->FormFields($this->controller);
        $stepValidator = $step->Validator();

        $actions = new FieldList();

        if (!$process->currentOrder()->getIsPaid()) {
            $currentIndex       = $process->currentStepIndex();
            $currentStepSegment = $process->currentStep()['url_segment'];
            $this->process->moveStep('rewind', $this);
            $previousStepSegment = $process->currentStep()['url_segment'];
            $process->setStepIndexesFromIndex($currentIndex);

            if ($previousStepSegment != $currentStepSegment) {
                $link = Controller::curr()->Link($previousStepSegment);
                $actions->push(LiteralField::create('previousstep', '<a href="' . $link . '" class="btn btn-danger">Previous Step</a>'));
            }
        }

        if ($process->nextStep()) {
            $actions->push(new FormAction('nextstep', 'Next Step'));
        }


        $this->extend('updateFormFields', $fields);
        $this->extend('updateFormActions', $actions);
        $this->extend('updateStepValidator', $stepValidator);

        $fields->push(new HiddenField('Step', '', get_class($step)));

        $step->updateForm($this);
        parent::__construct(Controller::curr(), 'CheckoutForm', $fields, $actions, $stepValidator);
    }

    public function nextstep(array $data, CheckoutForm $form, SS_HTTPRequest $request = null)
    {
        $controller = $this->controller;
        if (($response = $this->step->handleSubmission($data, $form, $request)) !== false) {

            //If the step returned a silverstripe response itself we'll just return that
            if (is_a($response, 'SS_HTTPResponse')) return $response;

            //The next steps may not need us to redirect to them to process
            //so we ask them to short circuit and if so we advance to the next step

            $this->process->moveStep('advance', $this);
            $stepSegment = $this->process->currentStep()['url_segment'];

            //send the user off to the next step
            return $controller->redirect($controller->Link($stepSegment));
        } else {
            return $controller->redirectBack();
        }
    }

    public function previousstep()
    {
        //similar to moving to the next step, we don't want to land on a step that
        //can shortcircuit when going backwards
        $this->process->moveStep('rewind', $this);
        $stepSegment = $this->process->currentStep()['url_segment'];

        return $this->controller->redirect($this->controller->Link($stepSegment));
    }

}