<?php

class BCMath
{

    public static function setPrecision($value, $precision = null)
    {
        if ($precision !== null) {
            $value = sprintf("%.{$precision}f", $value);
        }
        return $value;

    }

    public static function ensureString(&$value, $position = 'unknown', $precision = null)
    {
        if (!$value) $value = "0";
        $value = self::setPrecision($value, $precision);
        if (!is_string($value)) throw new Exception(ucfirst($position) . ' Value (' . $value . ')passed to BCMath is not a string');
    }

    public static function add($left, $right)
    {
        self::ensureString($left, 'left');
        self::ensureString($right, 'right');
        return bcadd($left, $right);
    }

    public static function multiply($left, $right)
    {
        self::ensureString($left, 'left');
        self::ensureString($right, 'right');
        return bcmul($left, $right);
    }

    public static function divide($left, $right)
    {
        self::ensureString($left, 'left');
        self::ensureString($right, 'right');
        return bcdiv($left, $right);
    }

    public static function subtract($left, $right)
    {
        self::ensureString($left, 'left');
        self::ensureString($right, 'right');
        return bcsub($left, $right);
    }

    public static function compare($left, $right, $precision = null)
    {
        self::ensureString($left, 'left', $precision);
        self::ensureString($right, 'right', $precision);
        return bccomp($left, $right);
    }

    public static function gt($left, $right, $precision = null)
    {
        return self::compare($left, $right, $precision) === 1;
    }

    public static function gte($left, $right, $precision = null)
    {
        return self::gt($left, $right, $precision) || self::eq($left, $right, $precision);
    }

    public static function lt($left, $right, $precision = null)
    {
        return self::compare($left, $right, $precision) === -1;
    }

    public static function lte($left, $right, $precision = null)
    {
        return self::lt($left, $right, $precision) || self::eq($left, $right, $precision);
    }

    public static function eq($left, $right, $precision = null)
    {
        return self::compare($left, $right, $precision) === 0;
    }


}