<?php

/**
 * Class FoxcommerceCountry_AdminSection
 *
 * @mixin FoxcommerceCountry_AdminSection_TaxExtension
 */
class FoxcommerceCountry_AdminSection extends FoxcommerceAdminSection
{
    protected static $url_rule      = 'Countries';
    protected static $menu_title    = 'Countries & Regions';
    protected static $description   = 'Manage the countries and regions for your shop';

    public function updateCMSFields(FieldList $fields){
        $countriesConfig = GridFieldConfig_RecordEditor::create();
        $countriesField  = GridField::create('FoxcommerceCountries', 'Countries & Regions', FoxcommerceCountry::get(), $countriesConfig);
        $fields->addFieldToTab('Root.Main', $countriesField);
    }

}